// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model



/**
 * TD-SCDMA object for network measurement reports.
 */
public class TdscdmaNmrObj private constructor(builder: Builder) {
    /**
     * Cell parameters for TD-SCDMA network measurement reports object.
     */
    public val cellParams: kotlin.Int = requireNotNull(builder.cellParams) { "A non-null value must be provided for cellParams" }
    /**
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.
     */
    public val pathLoss: kotlin.Int? = builder.pathLoss
    /**
     * Code power of the received signal, measured in decibel-milliwatts (dBm).
     */
    public val rscp: kotlin.Int? = builder.rscp
    /**
     * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
     */
    public val uarfcn: kotlin.Int = requireNotNull(builder.uarfcn) { "A non-null value must be provided for uarfcn" }
    /**
     * UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
     */
    public val utranCid: kotlin.Int? = builder.utranCid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.TdscdmaNmrObj = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TdscdmaNmrObj(")
        append("cellParams=$cellParams,")
        append("pathLoss=$pathLoss,")
        append("rscp=$rscp,")
        append("uarfcn=$uarfcn,")
        append("utranCid=$utranCid")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellParams
        result = 31 * result + (pathLoss ?: 0)
        result = 31 * result + (rscp ?: 0)
        result = 31 * result + (uarfcn)
        result = 31 * result + (utranCid ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TdscdmaNmrObj

        if (cellParams != other.cellParams) return false
        if (pathLoss != other.pathLoss) return false
        if (rscp != other.rscp) return false
        if (uarfcn != other.uarfcn) return false
        if (utranCid != other.utranCid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.TdscdmaNmrObj = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Cell parameters for TD-SCDMA network measurement reports object.
         */
        public var cellParams: kotlin.Int? = null
        /**
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.
         */
        public var pathLoss: kotlin.Int? = null
        /**
         * Code power of the received signal, measured in decibel-milliwatts (dBm).
         */
        public var rscp: kotlin.Int? = null
        /**
         * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
         */
        public var uarfcn: kotlin.Int? = null
        /**
         * UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
         */
        public var utranCid: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.TdscdmaNmrObj) : this() {
            this.cellParams = x.cellParams
            this.pathLoss = x.pathLoss
            this.rscp = x.rscp
            this.uarfcn = x.uarfcn
            this.utranCid = x.utranCid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.TdscdmaNmrObj = TdscdmaNmrObj(this)

        internal fun correctErrors(): Builder {
            if (cellParams == null) cellParams = 0
            if (uarfcn == null) uarfcn = 0
            return this
        }
    }
}
