// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model



/**
 * Specify the list of gateways to which you want to send downlink data traffic when the wireless device is running in class B or class C mode.
 */
public class ParticipatingGateways private constructor(builder: Builder) {
    /**
     * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the chosen gateways from the previous uplink message transmission.
     */
    public val downlinkMode: aws.sdk.kotlin.services.iotwireless.model.DownlinkMode = requireNotNull(builder.downlinkMode) { "A non-null value must be provided for downlinkMode" }
    /**
     * The list of gateways that you want to use for sending the downlink data traffic.
     */
    public val gatewayList: List<GatewayListItem> = requireNotNull(builder.gatewayList) { "A non-null value must be provided for gatewayList" }
    /**
     * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the next gateway.
     */
    public val transmissionInterval: kotlin.Int = requireNotNull(builder.transmissionInterval) { "A non-null value must be provided for transmissionInterval" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGateways = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipatingGateways(")
        append("downlinkMode=$downlinkMode,")
        append("gatewayList=$gatewayList,")
        append("transmissionInterval=$transmissionInterval")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = downlinkMode.hashCode()
        result = 31 * result + (gatewayList.hashCode())
        result = 31 * result + (transmissionInterval)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipatingGateways

        if (downlinkMode != other.downlinkMode) return false
        if (gatewayList != other.gatewayList) return false
        if (transmissionInterval != other.transmissionInterval) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGateways = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether to send the downlink message in sequential mode or concurrent mode, or to use only the chosen gateways from the previous uplink message transmission.
         */
        public var downlinkMode: aws.sdk.kotlin.services.iotwireless.model.DownlinkMode? = null
        /**
         * The list of gateways that you want to use for sending the downlink data traffic.
         */
        public var gatewayList: List<GatewayListItem>? = null
        /**
         * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the payload to the next gateway.
         */
        public var transmissionInterval: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.ParticipatingGateways) : this() {
            this.downlinkMode = x.downlinkMode
            this.gatewayList = x.gatewayList
            this.transmissionInterval = x.transmissionInterval
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGateways = ParticipatingGateways(this)

        internal fun correctErrors(): Builder {
            if (downlinkMode == null) downlinkMode = DownlinkMode.SdkUnknown("no value provided")
            if (gatewayList == null) gatewayList = emptyList()
            if (transmissionInterval == null) transmissionInterval = 0
            return this
        }
    }
}
