// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.TraceContent
import aws.sdk.kotlin.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateNetworkAnalyzerConfigurationOperationSerializer: HttpSerialize<UpdateNetworkAnalyzerConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateNetworkAnalyzerConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.configurationName) { "configurationName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("network-analyzer-configurations"))
                add(PercentEncoding.SmithyLabel.encode("${input.configurationName}"))
            }
        }

        val payload = serializeUpdateNetworkAnalyzerConfigurationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateNetworkAnalyzerConfigurationOperationBody(context: ExecutionContext, input: UpdateNetworkAnalyzerConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val MULTICASTGROUPSTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MulticastGroupsToAdd"))
    val MULTICASTGROUPSTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MulticastGroupsToRemove"))
    val TRACECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TraceContent"))
    val WIRELESSDEVICESTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDevicesToAdd"))
    val WIRELESSDEVICESTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDevicesToRemove"))
    val WIRELESSGATEWAYSTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewaysToAdd"))
    val WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewaysToRemove"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(MULTICASTGROUPSTOADD_DESCRIPTOR)
        field(MULTICASTGROUPSTOREMOVE_DESCRIPTOR)
        field(TRACECONTENT_DESCRIPTOR)
        field(WIRELESSDEVICESTOADD_DESCRIPTOR)
        field(WIRELESSDEVICESTOREMOVE_DESCRIPTOR)
        field(WIRELESSGATEWAYSTOADD_DESCRIPTOR)
        field(WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.multicastGroupsToAdd != null) {
            listField(MULTICASTGROUPSTOADD_DESCRIPTOR) {
                for (el0 in input.multicastGroupsToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.multicastGroupsToRemove != null) {
            listField(MULTICASTGROUPSTOREMOVE_DESCRIPTOR) {
                for (el0 in input.multicastGroupsToRemove) {
                    serializeString(el0)
                }
            }
        }
        input.traceContent?.let { field(TRACECONTENT_DESCRIPTOR, it, ::serializeTraceContentDocument) }
        if (input.wirelessDevicesToAdd != null) {
            listField(WIRELESSDEVICESTOADD_DESCRIPTOR) {
                for (el0 in input.wirelessDevicesToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessDevicesToRemove != null) {
            listField(WIRELESSDEVICESTOREMOVE_DESCRIPTOR) {
                for (el0 in input.wirelessDevicesToRemove) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessGatewaysToAdd != null) {
            listField(WIRELESSGATEWAYSTOADD_DESCRIPTOR) {
                for (el0 in input.wirelessGatewaysToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessGatewaysToRemove != null) {
            listField(WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR) {
                for (el0 in input.wirelessGatewaysToRemove) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
