// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.ConnectionStatusEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.GetResourceEventConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.JoinEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.ProximityEventConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourceEventConfigurationOperationDeserializer: HttpDeserialize<GetResourceEventConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetResourceEventConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetResourceEventConfigurationError(context, call)
        }
        val builder = GetResourceEventConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceEventConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetResourceEventConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceEventConfigurationOperationBody(builder: GetResourceEventConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val DEVICEREGISTRATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceRegistrationState"))
    val JOIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Join"))
    val MESSAGEDELIVERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MessageDeliveryStatus"))
    val PROXIMITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proximity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(DEVICEREGISTRATIONSTATE_DESCRIPTOR)
        field(JOIN_DESCRIPTOR)
        field(MESSAGEDELIVERYSTATUS_DESCRIPTOR)
        field(PROXIMITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeConnectionStatusEventConfigurationDocument(deserializer)
                DEVICEREGISTRATIONSTATE_DESCRIPTOR.index -> builder.deviceRegistrationState = deserializeDeviceRegistrationStateEventConfigurationDocument(deserializer)
                JOIN_DESCRIPTOR.index -> builder.join = deserializeJoinEventConfigurationDocument(deserializer)
                MESSAGEDELIVERYSTATUS_DESCRIPTOR.index -> builder.messageDeliveryStatus = deserializeMessageDeliveryStatusEventConfigurationDocument(deserializer)
                PROXIMITY_DESCRIPTOR.index -> builder.proximity = deserializeProximityEventConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
