// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an import task for wireless devices.
 */
public class WirelessDeviceImportTask private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the wireless device import task.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time at which the import task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the Sidewalk destination that that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * The summary information of count of wireless devices in an import task that failed to onboarded to the import task.
     */
    public val failedImportedDeviceCount: kotlin.Long? = builder.failedImportedDeviceCount
    /**
     * The ID of the wireless device import task.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The summary information of count of wireless devices that are waiting for the control log to be added to an import task.
     */
    public val initializedImportedDeviceCount: kotlin.Long? = builder.initializedImportedDeviceCount
    /**
     * The summary information of count of wireless devices in an import task that have been onboarded to the import task.
     */
    public val onboardedImportedDeviceCount: kotlin.Long? = builder.onboardedImportedDeviceCount
    /**
     * The summary information of count of wireless devices in an import task that are waiting in the queue to be onboarded.
     */
    public val pendingImportedDeviceCount: kotlin.Long? = builder.pendingImportedDeviceCount
    /**
     * The Sidewalk-related information of the wireless device import task.
     */
    public val sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo? = builder.sidewalk
    /**
     * The status information of the wireless device import task.
     */
    public val status: aws.sdk.kotlin.services.iotwireless.model.ImportTaskStatus? = builder.status
    /**
     * The reason that provides additional information about the import task status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceImportTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WirelessDeviceImportTask(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("destinationName=$destinationName,")
        append("failedImportedDeviceCount=$failedImportedDeviceCount,")
        append("id=$id,")
        append("initializedImportedDeviceCount=$initializedImportedDeviceCount,")
        append("onboardedImportedDeviceCount=$onboardedImportedDeviceCount,")
        append("pendingImportedDeviceCount=$pendingImportedDeviceCount,")
        append("sidewalk=$sidewalk,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (failedImportedDeviceCount?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (initializedImportedDeviceCount?.hashCode() ?: 0)
        result = 31 * result + (onboardedImportedDeviceCount?.hashCode() ?: 0)
        result = 31 * result + (pendingImportedDeviceCount?.hashCode() ?: 0)
        result = 31 * result + (sidewalk?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WirelessDeviceImportTask

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (destinationName != other.destinationName) return false
        if (failedImportedDeviceCount != other.failedImportedDeviceCount) return false
        if (id != other.id) return false
        if (initializedImportedDeviceCount != other.initializedImportedDeviceCount) return false
        if (onboardedImportedDeviceCount != other.onboardedImportedDeviceCount) return false
        if (pendingImportedDeviceCount != other.pendingImportedDeviceCount) return false
        if (sidewalk != other.sidewalk) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceImportTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the wireless device import task.
         */
        public var arn: kotlin.String? = null
        /**
         * The time at which the import task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Sidewalk destination that that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless
         */
        public var destinationName: kotlin.String? = null
        /**
         * The summary information of count of wireless devices in an import task that failed to onboarded to the import task.
         */
        public var failedImportedDeviceCount: kotlin.Long? = null
        /**
         * The ID of the wireless device import task.
         */
        public var id: kotlin.String? = null
        /**
         * The summary information of count of wireless devices that are waiting for the control log to be added to an import task.
         */
        public var initializedImportedDeviceCount: kotlin.Long? = null
        /**
         * The summary information of count of wireless devices in an import task that have been onboarded to the import task.
         */
        public var onboardedImportedDeviceCount: kotlin.Long? = null
        /**
         * The summary information of count of wireless devices in an import task that are waiting in the queue to be onboarded.
         */
        public var pendingImportedDeviceCount: kotlin.Long? = null
        /**
         * The Sidewalk-related information of the wireless device import task.
         */
        public var sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo? = null
        /**
         * The status information of the wireless device import task.
         */
        public var status: aws.sdk.kotlin.services.iotwireless.model.ImportTaskStatus? = null
        /**
         * The reason that provides additional information about the import task status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceImportTask) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.destinationName = x.destinationName
            this.failedImportedDeviceCount = x.failedImportedDeviceCount
            this.id = x.id
            this.initializedImportedDeviceCount = x.initializedImportedDeviceCount
            this.onboardedImportedDeviceCount = x.onboardedImportedDeviceCount
            this.pendingImportedDeviceCount = x.pendingImportedDeviceCount
            this.sidewalk = x.sidewalk
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceImportTask = WirelessDeviceImportTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo] inside the given [block]
         */
        public fun sidewalk(block: aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo.Builder.() -> kotlin.Unit) {
            this.sidewalk = aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
