// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetPositionEstimateRequest private constructor(builder: Builder) {
    /**
     * Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position is resolved using HERE's cellular-based solver.
     */
    public val cellTowers: aws.sdk.kotlin.services.iotwireless.model.CellTowers? = builder.cellTowers
    /**
     * Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data. The position is resolved using the GNSS solver powered by LoRa Cloud.
     */
    public val gnss: aws.sdk.kotlin.services.iotwireless.model.Gnss? = builder.gnss
    /**
     * Retrieves an estimated device position by resolving the IP address information from the device. The position is resolved using MaxMind's IP-based solver.
     */
    public val ip: aws.sdk.kotlin.services.iotwireless.model.Ip? = builder.ip
    /**
     * Optional information that specifies the time when the position information will be resolved. It uses the Unix timestamp format. If not specified, the time at which the request was received will be used.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using HERE's Wi-Fi based solver.
     */
    public val wiFiAccessPoints: List<WiFiAccessPoint>? = builder.wiFiAccessPoints

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.GetPositionEstimateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPositionEstimateRequest(")
        append("cellTowers=$cellTowers,")
        append("gnss=$gnss,")
        append("ip=$ip,")
        append("timestamp=$timestamp,")
        append("wiFiAccessPoints=$wiFiAccessPoints")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellTowers?.hashCode() ?: 0
        result = 31 * result + (gnss?.hashCode() ?: 0)
        result = 31 * result + (ip?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (wiFiAccessPoints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPositionEstimateRequest

        if (cellTowers != other.cellTowers) return false
        if (gnss != other.gnss) return false
        if (ip != other.ip) return false
        if (timestamp != other.timestamp) return false
        if (wiFiAccessPoints != other.wiFiAccessPoints) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.GetPositionEstimateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Retrieves an estimated device position by resolving measurement data from cellular radio towers. The position is resolved using HERE's cellular-based solver.
         */
        public var cellTowers: aws.sdk.kotlin.services.iotwireless.model.CellTowers? = null
        /**
         * Retrieves an estimated device position by resolving the global navigation satellite system (GNSS) scan data. The position is resolved using the GNSS solver powered by LoRa Cloud.
         */
        public var gnss: aws.sdk.kotlin.services.iotwireless.model.Gnss? = null
        /**
         * Retrieves an estimated device position by resolving the IP address information from the device. The position is resolved using MaxMind's IP-based solver.
         */
        public var ip: aws.sdk.kotlin.services.iotwireless.model.Ip? = null
        /**
         * Optional information that specifies the time when the position information will be resolved. It uses the Unix timestamp format. If not specified, the time at which the request was received will be used.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Retrieves an estimated device position by resolving WLAN measurement data. The position is resolved using HERE's Wi-Fi based solver.
         */
        public var wiFiAccessPoints: List<WiFiAccessPoint>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.GetPositionEstimateRequest) : this() {
            this.cellTowers = x.cellTowers
            this.gnss = x.gnss
            this.ip = x.ip
            this.timestamp = x.timestamp
            this.wiFiAccessPoints = x.wiFiAccessPoints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.GetPositionEstimateRequest = GetPositionEstimateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.CellTowers] inside the given [block]
         */
        public fun cellTowers(block: aws.sdk.kotlin.services.iotwireless.model.CellTowers.Builder.() -> kotlin.Unit) {
            this.cellTowers = aws.sdk.kotlin.services.iotwireless.model.CellTowers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.Gnss] inside the given [block]
         */
        public fun gnss(block: aws.sdk.kotlin.services.iotwireless.model.Gnss.Builder.() -> kotlin.Unit) {
            this.gnss = aws.sdk.kotlin.services.iotwireless.model.Gnss.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.Ip] inside the given [block]
         */
        public fun ip(block: aws.sdk.kotlin.services.iotwireless.model.Ip.Builder.() -> kotlin.Unit) {
            this.ip = aws.sdk.kotlin.services.iotwireless.model.Ip.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
