// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.services.iotwireless.model.TraceContent
import aws.sdk.kotlin.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateNetworkAnalyzerConfigurationOperationSerializer: HttpSerialize<UpdateNetworkAnalyzerConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateNetworkAnalyzerConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "network-analyzer-configurations",
                "${input.configurationName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateNetworkAnalyzerConfigurationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateNetworkAnalyzerConfigurationOperationBody(context: ExecutionContext, input: UpdateNetworkAnalyzerConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val TRACECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TraceContent"))
    val WIRELESSDEVICESTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDevicesToAdd"))
    val WIRELESSDEVICESTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDevicesToRemove"))
    val WIRELESSGATEWAYSTOADD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewaysToAdd"))
    val WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewaysToRemove"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(TRACECONTENT_DESCRIPTOR)
        field(WIRELESSDEVICESTOADD_DESCRIPTOR)
        field(WIRELESSDEVICESTOREMOVE_DESCRIPTOR)
        field(WIRELESSGATEWAYSTOADD_DESCRIPTOR)
        field(WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.traceContent?.let { field(TRACECONTENT_DESCRIPTOR, it, ::serializeTraceContentDocument) }
        if (input.wirelessDevicesToAdd != null) {
            listField(WIRELESSDEVICESTOADD_DESCRIPTOR) {
                for (el0 in input.wirelessDevicesToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessDevicesToRemove != null) {
            listField(WIRELESSDEVICESTOREMOVE_DESCRIPTOR) {
                for (el0 in input.wirelessDevicesToRemove) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessGatewaysToAdd != null) {
            listField(WIRELESSGATEWAYSTOADD_DESCRIPTOR) {
                for (el0 in input.wirelessGatewaysToAdd) {
                    serializeString(el0)
                }
            }
        }
        if (input.wirelessGatewaysToRemove != null) {
            listField(WIRELESSGATEWAYSTOREMOVE_DESCRIPTOR) {
                for (el0 in input.wirelessGatewaysToRemove) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
