// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.services.iotwireless.model.SendDataToWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.WirelessMetadata
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendDataToWirelessDeviceOperationSerializer: HttpSerialize<SendDataToWirelessDeviceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendDataToWirelessDeviceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "wireless-devices",
                "${input.id}".encodeLabel(),
                "data",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeSendDataToWirelessDeviceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendDataToWirelessDeviceOperationBody(context: ExecutionContext, input: SendDataToWirelessDeviceRequest): ByteArray {
    val serializer = JsonSerializer()
    val PAYLOADDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PayloadData"))
    val TRANSMITMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TransmitMode"))
    val WIRELESSMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WirelessMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PAYLOADDATA_DESCRIPTOR)
        field(TRANSMITMODE_DESCRIPTOR)
        field(WIRELESSMETADATA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.payloadData?.let { field(PAYLOADDATA_DESCRIPTOR, it) }
        input.transmitMode?.let { field(TRANSMITMODE_DESCRIPTOR, it) }
        input.wirelessMetadata?.let { field(WIRELESSMETADATA_DESCRIPTOR, it, ::serializeWirelessMetadataDocument) }
    }
    return serializer.toByteArray()
}
