// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.LogLevel
import aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceLogOption
import aws.sdk.kotlin.services.iotwireless.model.WirelessGatewayLogOption
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLogLevelsByResourceTypesOperationDeserializer: HttpDeserialize<GetLogLevelsByResourceTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLogLevelsByResourceTypesResponse {
        if (!response.status.isSuccess()) {
            throwGetLogLevelsByResourceTypesError(context, response)
        }
        val builder = GetLogLevelsByResourceTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLogLevelsByResourceTypesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLogLevelsByResourceTypesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLogLevelsByResourceTypesOperationBody(builder: GetLogLevelsByResourceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFAULTLOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultLogLevel"))
    val WIRELESSDEVICELOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDeviceLogOptions"))
    val WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewayLogOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTLOGLEVEL_DESCRIPTOR)
        field(WIRELESSDEVICELOGOPTIONS_DESCRIPTOR)
        field(WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFAULTLOGLEVEL_DESCRIPTOR.index -> builder.defaultLogLevel = deserializeString().let { LogLevel.fromValue(it) }
                WIRELESSDEVICELOGOPTIONS_DESCRIPTOR.index -> builder.wirelessDeviceLogOptions =
                    deserializer.deserializeList(WIRELESSDEVICELOGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<WirelessDeviceLogOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWirelessDeviceLogOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR.index -> builder.wirelessGatewayLogOptions =
                    deserializer.deserializeList(WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<WirelessGatewayLogOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWirelessGatewayLogOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
