// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.JoinResourceTypeEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.ProximityResourceTypeEventConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetEventConfigurationByResourceTypesOperationDeserializer: HttpDeserialize<GetEventConfigurationByResourceTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEventConfigurationByResourceTypesResponse {
        if (!response.status.isSuccess()) {
            throwGetEventConfigurationByResourceTypesError(context, response)
        }
        val builder = GetEventConfigurationByResourceTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEventConfigurationByResourceTypesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEventConfigurationByResourceTypesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEventConfigurationByResourceTypesOperationBody(builder: GetEventConfigurationByResourceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val DEVICEREGISTRATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceRegistrationState"))
    val JOIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Join"))
    val MESSAGEDELIVERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MessageDeliveryStatus"))
    val PROXIMITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proximity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(DEVICEREGISTRATIONSTATE_DESCRIPTOR)
        field(JOIN_DESCRIPTOR)
        field(MESSAGEDELIVERYSTATUS_DESCRIPTOR)
        field(PROXIMITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeConnectionStatusResourceTypeEventConfigurationDocument(deserializer)
                DEVICEREGISTRATIONSTATE_DESCRIPTOR.index -> builder.deviceRegistrationState = deserializeDeviceRegistrationStateResourceTypeEventConfigurationDocument(deserializer)
                JOIN_DESCRIPTOR.index -> builder.join = deserializeJoinResourceTypeEventConfigurationDocument(deserializer)
                MESSAGEDELIVERYSTATUS_DESCRIPTOR.index -> builder.messageDeliveryStatus = deserializeMessageDeliveryStatusResourceTypeEventConfigurationDocument(deserializer)
                PROXIMITY_DESCRIPTOR.index -> builder.proximity = deserializeProximityResourceTypeEventConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
