// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.services.iotwireless.model.ConnectionStatusEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.EventNotificationPartnerType
import aws.sdk.kotlin.services.iotwireless.model.IdentifierType
import aws.sdk.kotlin.services.iotwireless.model.JoinEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.ProximityEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.UpdateResourceEventConfigurationRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateResourceEventConfigurationOperationSerializer: HttpSerialize<UpdateResourceEventConfigurationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateResourceEventConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "event-configurations",
                "${input.identifier}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.identifierType != null) append("identifierType", input.identifierType.value)
                if (input.partnerType != null) append("partnerType", input.partnerType.value)
            }
        }

        val payload = serializeUpdateResourceEventConfigurationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateResourceEventConfigurationOperationBody(context: ExecutionContext, input: UpdateResourceEventConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val DEVICEREGISTRATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceRegistrationState"))
    val JOIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Join"))
    val MESSAGEDELIVERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MessageDeliveryStatus"))
    val PROXIMITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proximity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(DEVICEREGISTRATIONSTATE_DESCRIPTOR)
        field(JOIN_DESCRIPTOR)
        field(MESSAGEDELIVERYSTATUS_DESCRIPTOR)
        field(PROXIMITY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.connectionStatus?.let { field(CONNECTIONSTATUS_DESCRIPTOR, it, ::serializeConnectionStatusEventConfigurationDocument) }
        input.deviceRegistrationState?.let { field(DEVICEREGISTRATIONSTATE_DESCRIPTOR, it, ::serializeDeviceRegistrationStateEventConfigurationDocument) }
        input.join?.let { field(JOIN_DESCRIPTOR, it, ::serializeJoinEventConfigurationDocument) }
        input.messageDeliveryStatus?.let { field(MESSAGEDELIVERYSTATUS_DESCRIPTOR, it, ::serializeMessageDeliveryStatusEventConfigurationDocument) }
        input.proximity?.let { field(PROXIMITY_DESCRIPTOR, it, ::serializeProximityEventConfigurationDocument) }
    }
    return serializer.toByteArray()
}
