// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask
import aws.sdk.kotlin.services.iotwireless.model.UpdateFuotaTaskRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFuotaTaskOperationSerializer: HttpSerialize<UpdateFuotaTaskRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFuotaTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "fuota-tasks",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFuotaTaskOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFuotaTaskOperationBody(context: ExecutionContext, input: UpdateFuotaTaskRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FIRMWAREUPDATEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirmwareUpdateImage"))
    val FIRMWAREUPDATEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirmwareUpdateRole"))
    val LORAWAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoRaWAN"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(FIRMWAREUPDATEIMAGE_DESCRIPTOR)
        field(FIRMWAREUPDATEROLE_DESCRIPTOR)
        field(LORAWAN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.firmwareUpdateImage?.let { field(FIRMWAREUPDATEIMAGE_DESCRIPTOR, it) }
        input.firmwareUpdateRole?.let { field(FIRMWAREUPDATEROLE_DESCRIPTOR, it) }
        input.loRaWan?.let { field(LORAWAN_DESCRIPTOR, it, ::serializeLoRaWanFuotaTaskDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
