// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.UpdateWirelessGatewayTaskCreate
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWirelessGatewayTaskDefinitionOperationDeserializer: HttpDeserialize<GetWirelessGatewayTaskDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWirelessGatewayTaskDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwGetWirelessGatewayTaskDefinitionError(context, response)
        }
        val builder = GetWirelessGatewayTaskDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWirelessGatewayTaskDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWirelessGatewayTaskDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessGatewayTaskDefinitionOperationBody(builder: GetWirelessGatewayTaskDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val AUTOCREATETASKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoCreateTasks"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val UPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Update"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AUTOCREATETASKS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(UPDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTOCREATETASKS_DESCRIPTOR.index -> builder.autoCreateTasks = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                UPDATE_DESCRIPTOR.index -> builder.update = deserializeUpdateWirelessGatewayTaskCreateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
