// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.ConnectionStatus
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWirelessGatewayStatisticsOperationDeserializer: HttpDeserialize<GetWirelessGatewayStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWirelessGatewayStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetWirelessGatewayStatisticsError(context, response)
        }
        val builder = GetWirelessGatewayStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWirelessGatewayStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWirelessGatewayStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessGatewayStatisticsOperationBody(builder: GetWirelessGatewayStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionStatus"))
    val LASTUPLINKRECEIVEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastUplinkReceivedAt"))
    val WIRELESSGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessGatewayId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(LASTUPLINKRECEIVEDAT_DESCRIPTOR)
        field(WIRELESSGATEWAYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeString().let { ConnectionStatus.fromValue(it) }
                LASTUPLINKRECEIVEDAT_DESCRIPTOR.index -> builder.lastUplinkReceivedAt = deserializeString()
                WIRELESSGATEWAYID_DESCRIPTOR.index -> builder.wirelessGatewayId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
