// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotwireless.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotwireless.model.*
import aws.sdk.kotlin.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessDeviceWithThingResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest
import aws.sdk.kotlin.services.iotwireless.model.AssociateWirelessGatewayWithThingResponse
import aws.sdk.kotlin.services.iotwireless.model.CancelMulticastGroupSessionRequest
import aws.sdk.kotlin.services.iotwireless.model.CancelMulticastGroupSessionResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateDestinationRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateDestinationResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateDeviceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateDeviceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateNetworkAnalyzerConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateServiceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateServiceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteDestinationRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteDestinationResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteDeviceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteDeviceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteQueuedMessagesRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteQueuedMessagesResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteServiceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteServiceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.DeleteWirelessGatewayTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessDeviceFromThingResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessGatewayFromThingRequest
import aws.sdk.kotlin.services.iotwireless.model.DisassociateWirelessGatewayFromThingResponse
import aws.sdk.kotlin.services.iotwireless.model.GetDestinationRequest
import aws.sdk.kotlin.services.iotwireless.model.GetDestinationResponse
import aws.sdk.kotlin.services.iotwireless.model.GetDeviceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.GetDeviceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.GetEventConfigurationByResourceTypesRequest
import aws.sdk.kotlin.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.GetFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.GetFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.GetLogLevelsByResourceTypesRequest
import aws.sdk.kotlin.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.GetMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.GetMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.GetMulticastGroupSessionRequest
import aws.sdk.kotlin.services.iotwireless.model.GetMulticastGroupSessionResponse
import aws.sdk.kotlin.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.GetPartnerAccountRequest
import aws.sdk.kotlin.services.iotwireless.model.GetPartnerAccountResponse
import aws.sdk.kotlin.services.iotwireless.model.GetPositionConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.GetPositionConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.GetPositionRequest
import aws.sdk.kotlin.services.iotwireless.model.GetPositionResponse
import aws.sdk.kotlin.services.iotwireless.model.GetResourceEventConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.GetResourceEventConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.GetResourceLogLevelRequest
import aws.sdk.kotlin.services.iotwireless.model.GetResourceLogLevelResponse
import aws.sdk.kotlin.services.iotwireless.model.GetServiceEndpointRequest
import aws.sdk.kotlin.services.iotwireless.model.GetServiceEndpointResponse
import aws.sdk.kotlin.services.iotwireless.model.GetServiceProfileRequest
import aws.sdk.kotlin.services.iotwireless.model.GetServiceProfileResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceStatisticsRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayCertificateRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayCertificateResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayStatisticsRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.ListDestinationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListDestinationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListDeviceProfilesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListDeviceProfilesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListEventConfigurationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListEventConfigurationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListFuotaTasksRequest
import aws.sdk.kotlin.services.iotwireless.model.ListFuotaTasksResponse
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListPartnerAccountsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListPartnerAccountsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListPositionConfigurationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListPositionConfigurationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListQueuedMessagesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListQueuedMessagesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListServiceProfilesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListServiceProfilesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotwireless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessDevicesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessDevicesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewaysRequest
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewaysResponse
import aws.sdk.kotlin.services.iotwireless.model.PutPositionConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.PutPositionConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.PutResourceLogLevelRequest
import aws.sdk.kotlin.services.iotwireless.model.PutResourceLogLevelResponse
import aws.sdk.kotlin.services.iotwireless.model.ResetAllResourceLogLevelsRequest
import aws.sdk.kotlin.services.iotwireless.model.ResetAllResourceLogLevelsResponse
import aws.sdk.kotlin.services.iotwireless.model.ResetResourceLogLevelRequest
import aws.sdk.kotlin.services.iotwireless.model.ResetResourceLogLevelResponse
import aws.sdk.kotlin.services.iotwireless.model.SendDataToMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.SendDataToMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.SendDataToWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.SendDataToWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.StartFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.StartFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.StartMulticastGroupSessionRequest
import aws.sdk.kotlin.services.iotwireless.model.StartMulticastGroupSessionResponse
import aws.sdk.kotlin.services.iotwireless.model.TagResourceRequest
import aws.sdk.kotlin.services.iotwireless.model.TagResourceResponse
import aws.sdk.kotlin.services.iotwireless.model.TestWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.TestWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotwireless.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateDestinationRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateDestinationResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateEventConfigurationByResourceTypesRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateEventConfigurationByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateLogLevelsByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateMulticastGroupRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateMulticastGroupResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdatePartnerAccountRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdatePartnerAccountResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdatePositionRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdatePositionResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateResourceEventConfigurationRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateResourceEventConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateWirelessDeviceRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateWirelessDeviceResponse
import aws.sdk.kotlin.services.iotwireless.model.UpdateWirelessGatewayRequest
import aws.sdk.kotlin.services.iotwireless.model.UpdateWirelessGatewayResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS IoT Wireless provides bi-directional communication between internet-connected wireless devices and the AWS Cloud. To onboard both LoRaWAN and Sidewalk devices to AWS IoT, use the IoT Wireless API. These wireless devices use the Low Power Wide Area Networking (LPWAN) communication protocol to communicate with AWS IoT.
 *
 * Using the API, you can perform create, read, update, and delete operations for your wireless devices, gateways, destinations, and profiles. After onboarding your devices, you can use the API operations to set log levels and monitor your devices with CloudWatch.
 *
 * You can also use the API operations to create multicast groups and schedule a multicast session for sending a downlink message to devices in the group. By using Firmware Updates Over-The-Air (FUOTA) API operations, you can create a FUOTA task and schedule a session to update the firmware of individual devices or an entire group of devices in a multicast group.
 */
public interface IotWirelessClient : SdkClient {

    override val serviceName: String
        get() = "IoT Wireless"
    /**
     * IotWirelessClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IotWirelessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotWirelessClient(config)
        }

        public operator fun invoke(config: Config): IotWirelessClient = DefaultIotWirelessClient(config)

        /**
         * Construct a [IotWirelessClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotWirelessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIotWirelessClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a partner account with your AWS account.
     */
    public suspend fun associateAwsAccountWithPartnerAccount(input: AssociateAwsAccountWithPartnerAccountRequest): AssociateAwsAccountWithPartnerAccountResponse

    /**
     * Associate a multicast group with a FUOTA task.
     */
    public suspend fun associateMulticastGroupWithFuotaTask(input: AssociateMulticastGroupWithFuotaTaskRequest): AssociateMulticastGroupWithFuotaTaskResponse

    /**
     * Associate a wireless device with a FUOTA task.
     */
    public suspend fun associateWirelessDeviceWithFuotaTask(input: AssociateWirelessDeviceWithFuotaTaskRequest): AssociateWirelessDeviceWithFuotaTaskResponse

    /**
     * Associates a wireless device with a multicast group.
     */
    public suspend fun associateWirelessDeviceWithMulticastGroup(input: AssociateWirelessDeviceWithMulticastGroupRequest): AssociateWirelessDeviceWithMulticastGroupResponse

    /**
     * Associates a wireless device with a thing.
     */
    public suspend fun associateWirelessDeviceWithThing(input: AssociateWirelessDeviceWithThingRequest): AssociateWirelessDeviceWithThingResponse

    /**
     * Associates a wireless gateway with a certificate.
     */
    public suspend fun associateWirelessGatewayWithCertificate(input: AssociateWirelessGatewayWithCertificateRequest): AssociateWirelessGatewayWithCertificateResponse

    /**
     * Associates a wireless gateway with a thing.
     */
    public suspend fun associateWirelessGatewayWithThing(input: AssociateWirelessGatewayWithThingRequest): AssociateWirelessGatewayWithThingResponse

    /**
     * Cancels an existing multicast group session.
     */
    public suspend fun cancelMulticastGroupSession(input: CancelMulticastGroupSessionRequest): CancelMulticastGroupSessionResponse

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    public suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse

    /**
     * Creates a new device profile.
     */
    public suspend fun createDeviceProfile(input: CreateDeviceProfileRequest = CreateDeviceProfileRequest {}): CreateDeviceProfileResponse

    /**
     * Creates a FUOTA task.
     */
    public suspend fun createFuotaTask(input: CreateFuotaTaskRequest): CreateFuotaTaskResponse

    /**
     * Creates a multicast group.
     */
    public suspend fun createMulticastGroup(input: CreateMulticastGroupRequest): CreateMulticastGroupResponse

    /**
     * Creates a new network analyzer configuration.
     */
    public suspend fun createNetworkAnalyzerConfiguration(input: CreateNetworkAnalyzerConfigurationRequest): CreateNetworkAnalyzerConfigurationResponse

    /**
     * Creates a new service profile.
     */
    public suspend fun createServiceProfile(input: CreateServiceProfileRequest = CreateServiceProfileRequest {}): CreateServiceProfileResponse

    /**
     * Provisions a wireless device.
     */
    public suspend fun createWirelessDevice(input: CreateWirelessDeviceRequest): CreateWirelessDeviceResponse

    /**
     * Provisions a wireless gateway.
     */
    public suspend fun createWirelessGateway(input: CreateWirelessGatewayRequest): CreateWirelessGatewayResponse

    /**
     * Creates a task for a wireless gateway.
     */
    public suspend fun createWirelessGatewayTask(input: CreateWirelessGatewayTaskRequest): CreateWirelessGatewayTaskResponse

    /**
     * Creates a gateway task definition.
     */
    public suspend fun createWirelessGatewayTaskDefinition(input: CreateWirelessGatewayTaskDefinitionRequest): CreateWirelessGatewayTaskDefinitionResponse

    /**
     * Deletes a destination.
     */
    public suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse

    /**
     * Deletes a device profile.
     */
    public suspend fun deleteDeviceProfile(input: DeleteDeviceProfileRequest): DeleteDeviceProfileResponse

    /**
     * Deletes a FUOTA task.
     */
    public suspend fun deleteFuotaTask(input: DeleteFuotaTaskRequest): DeleteFuotaTaskResponse

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    public suspend fun deleteMulticastGroup(input: DeleteMulticastGroupRequest): DeleteMulticastGroupResponse

    /**
     * Deletes a network analyzer configuration.
     */
    public suspend fun deleteNetworkAnalyzerConfiguration(input: DeleteNetworkAnalyzerConfigurationRequest): DeleteNetworkAnalyzerConfigurationResponse

    /**
     * Remove queued messages from the downlink queue.
     */
    public suspend fun deleteQueuedMessages(input: DeleteQueuedMessagesRequest): DeleteQueuedMessagesResponse

    /**
     * Deletes a service profile.
     */
    public suspend fun deleteServiceProfile(input: DeleteServiceProfileRequest): DeleteServiceProfileResponse

    /**
     * Deletes a wireless device.
     */
    public suspend fun deleteWirelessDevice(input: DeleteWirelessDeviceRequest): DeleteWirelessDeviceResponse

    /**
     * Deletes a wireless gateway.
     */
    public suspend fun deleteWirelessGateway(input: DeleteWirelessGatewayRequest): DeleteWirelessGatewayResponse

    /**
     * Deletes a wireless gateway task.
     */
    public suspend fun deleteWirelessGatewayTask(input: DeleteWirelessGatewayTaskRequest): DeleteWirelessGatewayTaskResponse

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    public suspend fun deleteWirelessGatewayTaskDefinition(input: DeleteWirelessGatewayTaskDefinitionRequest): DeleteWirelessGatewayTaskDefinitionResponse

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    public suspend fun disassociateAwsAccountFromPartnerAccount(input: DisassociateAwsAccountFromPartnerAccountRequest): DisassociateAwsAccountFromPartnerAccountResponse

    /**
     * Disassociates a multicast group from a fuota task.
     */
    public suspend fun disassociateMulticastGroupFromFuotaTask(input: DisassociateMulticastGroupFromFuotaTaskRequest): DisassociateMulticastGroupFromFuotaTaskResponse

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    public suspend fun disassociateWirelessDeviceFromFuotaTask(input: DisassociateWirelessDeviceFromFuotaTaskRequest): DisassociateWirelessDeviceFromFuotaTaskResponse

    /**
     * Disassociates a wireless device from a multicast group.
     */
    public suspend fun disassociateWirelessDeviceFromMulticastGroup(input: DisassociateWirelessDeviceFromMulticastGroupRequest): DisassociateWirelessDeviceFromMulticastGroupResponse

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    public suspend fun disassociateWirelessDeviceFromThing(input: DisassociateWirelessDeviceFromThingRequest): DisassociateWirelessDeviceFromThingResponse

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    public suspend fun disassociateWirelessGatewayFromCertificate(input: DisassociateWirelessGatewayFromCertificateRequest): DisassociateWirelessGatewayFromCertificateResponse

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    public suspend fun disassociateWirelessGatewayFromThing(input: DisassociateWirelessGatewayFromThingRequest): DisassociateWirelessGatewayFromThingResponse

    /**
     * Gets information about a destination.
     */
    public suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse

    /**
     * Gets information about a device profile.
     */
    public suspend fun getDeviceProfile(input: GetDeviceProfileRequest): GetDeviceProfileResponse

    /**
     * Get the event configuration based on resource types.
     */
    public suspend fun getEventConfigurationByResourceTypes(input: GetEventConfigurationByResourceTypesRequest = GetEventConfigurationByResourceTypesRequest {}): GetEventConfigurationByResourceTypesResponse

    /**
     * Gets information about a FUOTA task.
     */
    public suspend fun getFuotaTask(input: GetFuotaTaskRequest): GetFuotaTaskResponse

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    public suspend fun getLogLevelsByResourceTypes(input: GetLogLevelsByResourceTypesRequest = GetLogLevelsByResourceTypesRequest {}): GetLogLevelsByResourceTypesResponse

    /**
     * Gets information about a multicast group.
     */
    public suspend fun getMulticastGroup(input: GetMulticastGroupRequest): GetMulticastGroupResponse

    /**
     * Gets information about a multicast group session.
     */
    public suspend fun getMulticastGroupSession(input: GetMulticastGroupSessionRequest): GetMulticastGroupSessionResponse

    /**
     * Get network analyzer configuration.
     */
    public suspend fun getNetworkAnalyzerConfiguration(input: GetNetworkAnalyzerConfigurationRequest): GetNetworkAnalyzerConfigurationResponse

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    public suspend fun getPartnerAccount(input: GetPartnerAccountRequest): GetPartnerAccountResponse

    /**
     * Get the position information for a given resource.
     */
    public suspend fun getPosition(input: GetPositionRequest): GetPositionResponse

    /**
     * Get position configuration for a given resource.
     */
    public suspend fun getPositionConfiguration(input: GetPositionConfigurationRequest): GetPositionConfigurationResponse

    /**
     * Get the event configuration for a particular resource identifier.
     */
    public suspend fun getResourceEventConfiguration(input: GetResourceEventConfigurationRequest): GetResourceEventConfigurationResponse

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    public suspend fun getResourceLogLevel(input: GetResourceLogLevelRequest): GetResourceLogLevelResponse

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    public suspend fun getServiceEndpoint(input: GetServiceEndpointRequest = GetServiceEndpointRequest {}): GetServiceEndpointResponse

    /**
     * Gets information about a service profile.
     */
    public suspend fun getServiceProfile(input: GetServiceProfileRequest): GetServiceProfileResponse

    /**
     * Gets information about a wireless device.
     */
    public suspend fun getWirelessDevice(input: GetWirelessDeviceRequest): GetWirelessDeviceResponse

    /**
     * Gets operating information about a wireless device.
     */
    public suspend fun getWirelessDeviceStatistics(input: GetWirelessDeviceStatisticsRequest): GetWirelessDeviceStatisticsResponse

    /**
     * Gets information about a wireless gateway.
     */
    public suspend fun getWirelessGateway(input: GetWirelessGatewayRequest): GetWirelessGatewayResponse

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    public suspend fun getWirelessGatewayCertificate(input: GetWirelessGatewayCertificateRequest): GetWirelessGatewayCertificateResponse

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    public suspend fun getWirelessGatewayFirmwareInformation(input: GetWirelessGatewayFirmwareInformationRequest): GetWirelessGatewayFirmwareInformationResponse

    /**
     * Gets operating information about a wireless gateway.
     */
    public suspend fun getWirelessGatewayStatistics(input: GetWirelessGatewayStatisticsRequest): GetWirelessGatewayStatisticsResponse

    /**
     * Gets information about a wireless gateway task.
     */
    public suspend fun getWirelessGatewayTask(input: GetWirelessGatewayTaskRequest): GetWirelessGatewayTaskResponse

    /**
     * Gets information about a wireless gateway task definition.
     */
    public suspend fun getWirelessGatewayTaskDefinition(input: GetWirelessGatewayTaskDefinitionRequest): GetWirelessGatewayTaskDefinitionResponse

    /**
     * Lists the destinations registered to your AWS account.
     */
    public suspend fun listDestinations(input: ListDestinationsRequest = ListDestinationsRequest {}): ListDestinationsResponse

    /**
     * Lists the device profiles registered to your AWS account.
     */
    public suspend fun listDeviceProfiles(input: ListDeviceProfilesRequest = ListDeviceProfilesRequest {}): ListDeviceProfilesResponse

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    public suspend fun listEventConfigurations(input: ListEventConfigurationsRequest): ListEventConfigurationsResponse

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    public suspend fun listFuotaTasks(input: ListFuotaTasksRequest = ListFuotaTasksRequest {}): ListFuotaTasksResponse

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    public suspend fun listMulticastGroups(input: ListMulticastGroupsRequest = ListMulticastGroupsRequest {}): ListMulticastGroupsResponse

    /**
     * List all multicast groups associated with a fuota task.
     */
    public suspend fun listMulticastGroupsByFuotaTask(input: ListMulticastGroupsByFuotaTaskRequest): ListMulticastGroupsByFuotaTaskResponse

    /**
     * Lists the network analyzer configurations.
     */
    public suspend fun listNetworkAnalyzerConfigurations(input: ListNetworkAnalyzerConfigurationsRequest = ListNetworkAnalyzerConfigurationsRequest {}): ListNetworkAnalyzerConfigurationsResponse

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    public suspend fun listPartnerAccounts(input: ListPartnerAccountsRequest = ListPartnerAccountsRequest {}): ListPartnerAccountsResponse

    /**
     * List position configurations for a given resource, such as positioning solvers.
     */
    public suspend fun listPositionConfigurations(input: ListPositionConfigurationsRequest = ListPositionConfigurationsRequest {}): ListPositionConfigurationsResponse

    /**
     * List queued messages in the downlink queue.
     */
    public suspend fun listQueuedMessages(input: ListQueuedMessagesRequest): ListQueuedMessagesResponse

    /**
     * Lists the service profiles registered to your AWS account.
     */
    public suspend fun listServiceProfiles(input: ListServiceProfilesRequest = ListServiceProfilesRequest {}): ListServiceProfilesResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    public suspend fun listWirelessDevices(input: ListWirelessDevicesRequest = ListWirelessDevicesRequest {}): ListWirelessDevicesResponse

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    public suspend fun listWirelessGatewayTaskDefinitions(input: ListWirelessGatewayTaskDefinitionsRequest = ListWirelessGatewayTaskDefinitionsRequest {}): ListWirelessGatewayTaskDefinitionsResponse

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    public suspend fun listWirelessGateways(input: ListWirelessGatewaysRequest = ListWirelessGatewaysRequest {}): ListWirelessGatewaysResponse

    /**
     * Put position configuration for a given resource.
     */
    public suspend fun putPositionConfiguration(input: PutPositionConfigurationRequest): PutPositionConfigurationResponse

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    public suspend fun putResourceLogLevel(input: PutResourceLogLevelRequest): PutResourceLogLevelResponse

    /**
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     */
    public suspend fun resetAllResourceLogLevels(input: ResetAllResourceLogLevelsRequest = ResetAllResourceLogLevelsRequest {}): ResetAllResourceLogLevelsResponse

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    public suspend fun resetResourceLogLevel(input: ResetResourceLogLevelRequest): ResetResourceLogLevelResponse

    /**
     * Sends the specified data to a multicast group.
     */
    public suspend fun sendDataToMulticastGroup(input: SendDataToMulticastGroupRequest): SendDataToMulticastGroupResponse

    /**
     * Sends a decrypted application data frame to a device.
     */
    public suspend fun sendDataToWirelessDevice(input: SendDataToWirelessDeviceRequest): SendDataToWirelessDeviceResponse

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    public suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(input: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    public suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(input: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse

    /**
     * Starts a FUOTA task.
     */
    public suspend fun startFuotaTask(input: StartFuotaTaskRequest): StartFuotaTaskResponse

    /**
     * Starts a multicast group session.
     */
    public suspend fun startMulticastGroupSession(input: StartMulticastGroupSessionRequest): StartMulticastGroupSessionResponse

    /**
     * Adds a tag to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    public suspend fun testWirelessDevice(input: TestWirelessDeviceRequest): TestWirelessDeviceResponse

    /**
     * Removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates properties of a destination.
     */
    public suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse

    /**
     * Update the event configuration based on resource types.
     */
    public suspend fun updateEventConfigurationByResourceTypes(input: UpdateEventConfigurationByResourceTypesRequest = UpdateEventConfigurationByResourceTypesRequest {}): UpdateEventConfigurationByResourceTypesResponse

    /**
     * Updates properties of a FUOTA task.
     */
    public suspend fun updateFuotaTask(input: UpdateFuotaTaskRequest): UpdateFuotaTaskResponse

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    public suspend fun updateLogLevelsByResourceTypes(input: UpdateLogLevelsByResourceTypesRequest = UpdateLogLevelsByResourceTypesRequest {}): UpdateLogLevelsByResourceTypesResponse

    /**
     * Updates properties of a multicast group session.
     */
    public suspend fun updateMulticastGroup(input: UpdateMulticastGroupRequest): UpdateMulticastGroupResponse

    /**
     * Update network analyzer configuration.
     */
    public suspend fun updateNetworkAnalyzerConfiguration(input: UpdateNetworkAnalyzerConfigurationRequest): UpdateNetworkAnalyzerConfigurationResponse

    /**
     * Updates properties of a partner account.
     */
    public suspend fun updatePartnerAccount(input: UpdatePartnerAccountRequest): UpdatePartnerAccountResponse

    /**
     * Update the position information of a resource.
     */
    public suspend fun updatePosition(input: UpdatePositionRequest): UpdatePositionResponse

    /**
     * Update the event configuration for a particular resource identifier.
     */
    public suspend fun updateResourceEventConfiguration(input: UpdateResourceEventConfigurationRequest): UpdateResourceEventConfigurationResponse

    /**
     * Updates properties of a wireless device.
     */
    public suspend fun updateWirelessDevice(input: UpdateWirelessDeviceRequest): UpdateWirelessDeviceResponse

    /**
     * Updates properties of a wireless gateway.
     */
    public suspend fun updateWirelessGateway(input: UpdateWirelessGatewayRequest): UpdateWirelessGatewayResponse
}

/**
 * Associates a partner account with your AWS account.
 */
public suspend inline fun IotWirelessClient.associateAwsAccountWithPartnerAccount(crossinline block: AssociateAwsAccountWithPartnerAccountRequest.Builder.() -> Unit): AssociateAwsAccountWithPartnerAccountResponse = associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.Builder().apply(block).build())

/**
 * Associate a multicast group with a FUOTA task.
 */
public suspend inline fun IotWirelessClient.associateMulticastGroupWithFuotaTask(crossinline block: AssociateMulticastGroupWithFuotaTaskRequest.Builder.() -> Unit): AssociateMulticastGroupWithFuotaTaskResponse = associateMulticastGroupWithFuotaTask(AssociateMulticastGroupWithFuotaTaskRequest.Builder().apply(block).build())

/**
 * Associate a wireless device with a FUOTA task.
 */
public suspend inline fun IotWirelessClient.associateWirelessDeviceWithFuotaTask(crossinline block: AssociateWirelessDeviceWithFuotaTaskRequest.Builder.() -> Unit): AssociateWirelessDeviceWithFuotaTaskResponse = associateWirelessDeviceWithFuotaTask(AssociateWirelessDeviceWithFuotaTaskRequest.Builder().apply(block).build())

/**
 * Associates a wireless device with a multicast group.
 */
public suspend inline fun IotWirelessClient.associateWirelessDeviceWithMulticastGroup(crossinline block: AssociateWirelessDeviceWithMulticastGroupRequest.Builder.() -> Unit): AssociateWirelessDeviceWithMulticastGroupResponse = associateWirelessDeviceWithMulticastGroup(AssociateWirelessDeviceWithMulticastGroupRequest.Builder().apply(block).build())

/**
 * Associates a wireless device with a thing.
 */
public suspend inline fun IotWirelessClient.associateWirelessDeviceWithThing(crossinline block: AssociateWirelessDeviceWithThingRequest.Builder.() -> Unit): AssociateWirelessDeviceWithThingResponse = associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.Builder().apply(block).build())

/**
 * Associates a wireless gateway with a certificate.
 */
public suspend inline fun IotWirelessClient.associateWirelessGatewayWithCertificate(crossinline block: AssociateWirelessGatewayWithCertificateRequest.Builder.() -> Unit): AssociateWirelessGatewayWithCertificateResponse = associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.Builder().apply(block).build())

/**
 * Associates a wireless gateway with a thing.
 */
public suspend inline fun IotWirelessClient.associateWirelessGatewayWithThing(crossinline block: AssociateWirelessGatewayWithThingRequest.Builder.() -> Unit): AssociateWirelessGatewayWithThingResponse = associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.Builder().apply(block).build())

/**
 * Cancels an existing multicast group session.
 */
public suspend inline fun IotWirelessClient.cancelMulticastGroupSession(crossinline block: CancelMulticastGroupSessionRequest.Builder.() -> Unit): CancelMulticastGroupSessionResponse = cancelMulticastGroupSession(CancelMulticastGroupSessionRequest.Builder().apply(block).build())

/**
 * Creates a new destination that maps a device message to an AWS IoT rule.
 */
public suspend inline fun IotWirelessClient.createDestination(crossinline block: CreateDestinationRequest.Builder.() -> Unit): CreateDestinationResponse = createDestination(CreateDestinationRequest.Builder().apply(block).build())

/**
 * Creates a new device profile.
 */
public suspend inline fun IotWirelessClient.createDeviceProfile(crossinline block: CreateDeviceProfileRequest.Builder.() -> Unit): CreateDeviceProfileResponse = createDeviceProfile(CreateDeviceProfileRequest.Builder().apply(block).build())

/**
 * Creates a FUOTA task.
 */
public suspend inline fun IotWirelessClient.createFuotaTask(crossinline block: CreateFuotaTaskRequest.Builder.() -> Unit): CreateFuotaTaskResponse = createFuotaTask(CreateFuotaTaskRequest.Builder().apply(block).build())

/**
 * Creates a multicast group.
 */
public suspend inline fun IotWirelessClient.createMulticastGroup(crossinline block: CreateMulticastGroupRequest.Builder.() -> Unit): CreateMulticastGroupResponse = createMulticastGroup(CreateMulticastGroupRequest.Builder().apply(block).build())

/**
 * Creates a new network analyzer configuration.
 */
public suspend inline fun IotWirelessClient.createNetworkAnalyzerConfiguration(crossinline block: CreateNetworkAnalyzerConfigurationRequest.Builder.() -> Unit): CreateNetworkAnalyzerConfigurationResponse = createNetworkAnalyzerConfiguration(CreateNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new service profile.
 */
public suspend inline fun IotWirelessClient.createServiceProfile(crossinline block: CreateServiceProfileRequest.Builder.() -> Unit): CreateServiceProfileResponse = createServiceProfile(CreateServiceProfileRequest.Builder().apply(block).build())

/**
 * Provisions a wireless device.
 */
public suspend inline fun IotWirelessClient.createWirelessDevice(crossinline block: CreateWirelessDeviceRequest.Builder.() -> Unit): CreateWirelessDeviceResponse = createWirelessDevice(CreateWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Provisions a wireless gateway.
 */
public suspend inline fun IotWirelessClient.createWirelessGateway(crossinline block: CreateWirelessGatewayRequest.Builder.() -> Unit): CreateWirelessGatewayResponse = createWirelessGateway(CreateWirelessGatewayRequest.Builder().apply(block).build())

/**
 * Creates a task for a wireless gateway.
 */
public suspend inline fun IotWirelessClient.createWirelessGatewayTask(crossinline block: CreateWirelessGatewayTaskRequest.Builder.() -> Unit): CreateWirelessGatewayTaskResponse = createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.Builder().apply(block).build())

/**
 * Creates a gateway task definition.
 */
public suspend inline fun IotWirelessClient.createWirelessGatewayTaskDefinition(crossinline block: CreateWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit): CreateWirelessGatewayTaskDefinitionResponse = createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a destination.
 */
public suspend inline fun IotWirelessClient.deleteDestination(crossinline block: DeleteDestinationRequest.Builder.() -> Unit): DeleteDestinationResponse = deleteDestination(DeleteDestinationRequest.Builder().apply(block).build())

/**
 * Deletes a device profile.
 */
public suspend inline fun IotWirelessClient.deleteDeviceProfile(crossinline block: DeleteDeviceProfileRequest.Builder.() -> Unit): DeleteDeviceProfileResponse = deleteDeviceProfile(DeleteDeviceProfileRequest.Builder().apply(block).build())

/**
 * Deletes a FUOTA task.
 */
public suspend inline fun IotWirelessClient.deleteFuotaTask(crossinline block: DeleteFuotaTaskRequest.Builder.() -> Unit): DeleteFuotaTaskResponse = deleteFuotaTask(DeleteFuotaTaskRequest.Builder().apply(block).build())

/**
 * Deletes a multicast group if it is not in use by a fuota task.
 */
public suspend inline fun IotWirelessClient.deleteMulticastGroup(crossinline block: DeleteMulticastGroupRequest.Builder.() -> Unit): DeleteMulticastGroupResponse = deleteMulticastGroup(DeleteMulticastGroupRequest.Builder().apply(block).build())

/**
 * Deletes a network analyzer configuration.
 */
public suspend inline fun IotWirelessClient.deleteNetworkAnalyzerConfiguration(crossinline block: DeleteNetworkAnalyzerConfigurationRequest.Builder.() -> Unit): DeleteNetworkAnalyzerConfigurationResponse = deleteNetworkAnalyzerConfiguration(DeleteNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

/**
 * Remove queued messages from the downlink queue.
 */
public suspend inline fun IotWirelessClient.deleteQueuedMessages(crossinline block: DeleteQueuedMessagesRequest.Builder.() -> Unit): DeleteQueuedMessagesResponse = deleteQueuedMessages(DeleteQueuedMessagesRequest.Builder().apply(block).build())

/**
 * Deletes a service profile.
 */
public suspend inline fun IotWirelessClient.deleteServiceProfile(crossinline block: DeleteServiceProfileRequest.Builder.() -> Unit): DeleteServiceProfileResponse = deleteServiceProfile(DeleteServiceProfileRequest.Builder().apply(block).build())

/**
 * Deletes a wireless device.
 */
public suspend inline fun IotWirelessClient.deleteWirelessDevice(crossinline block: DeleteWirelessDeviceRequest.Builder.() -> Unit): DeleteWirelessDeviceResponse = deleteWirelessDevice(DeleteWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Deletes a wireless gateway.
 */
public suspend inline fun IotWirelessClient.deleteWirelessGateway(crossinline block: DeleteWirelessGatewayRequest.Builder.() -> Unit): DeleteWirelessGatewayResponse = deleteWirelessGateway(DeleteWirelessGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a wireless gateway task.
 */
public suspend inline fun IotWirelessClient.deleteWirelessGatewayTask(crossinline block: DeleteWirelessGatewayTaskRequest.Builder.() -> Unit): DeleteWirelessGatewayTaskResponse = deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.Builder().apply(block).build())

/**
 * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
 */
public suspend inline fun IotWirelessClient.deleteWirelessGatewayTaskDefinition(crossinline block: DeleteWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit): DeleteWirelessGatewayTaskDefinitionResponse = deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
 */
public suspend inline fun IotWirelessClient.disassociateAwsAccountFromPartnerAccount(crossinline block: DisassociateAwsAccountFromPartnerAccountRequest.Builder.() -> Unit): DisassociateAwsAccountFromPartnerAccountResponse = disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.Builder().apply(block).build())

/**
 * Disassociates a multicast group from a fuota task.
 */
public suspend inline fun IotWirelessClient.disassociateMulticastGroupFromFuotaTask(crossinline block: DisassociateMulticastGroupFromFuotaTaskRequest.Builder.() -> Unit): DisassociateMulticastGroupFromFuotaTaskResponse = disassociateMulticastGroupFromFuotaTask(DisassociateMulticastGroupFromFuotaTaskRequest.Builder().apply(block).build())

/**
 * Disassociates a wireless device from a FUOTA task.
 */
public suspend inline fun IotWirelessClient.disassociateWirelessDeviceFromFuotaTask(crossinline block: DisassociateWirelessDeviceFromFuotaTaskRequest.Builder.() -> Unit): DisassociateWirelessDeviceFromFuotaTaskResponse = disassociateWirelessDeviceFromFuotaTask(DisassociateWirelessDeviceFromFuotaTaskRequest.Builder().apply(block).build())

/**
 * Disassociates a wireless device from a multicast group.
 */
public suspend inline fun IotWirelessClient.disassociateWirelessDeviceFromMulticastGroup(crossinline block: DisassociateWirelessDeviceFromMulticastGroupRequest.Builder.() -> Unit): DisassociateWirelessDeviceFromMulticastGroupResponse = disassociateWirelessDeviceFromMulticastGroup(DisassociateWirelessDeviceFromMulticastGroupRequest.Builder().apply(block).build())

/**
 * Disassociates a wireless device from its currently associated thing.
 */
public suspend inline fun IotWirelessClient.disassociateWirelessDeviceFromThing(crossinline block: DisassociateWirelessDeviceFromThingRequest.Builder.() -> Unit): DisassociateWirelessDeviceFromThingResponse = disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.Builder().apply(block).build())

/**
 * Disassociates a wireless gateway from its currently associated certificate.
 */
public suspend inline fun IotWirelessClient.disassociateWirelessGatewayFromCertificate(crossinline block: DisassociateWirelessGatewayFromCertificateRequest.Builder.() -> Unit): DisassociateWirelessGatewayFromCertificateResponse = disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.Builder().apply(block).build())

/**
 * Disassociates a wireless gateway from its currently associated thing.
 */
public suspend inline fun IotWirelessClient.disassociateWirelessGatewayFromThing(crossinline block: DisassociateWirelessGatewayFromThingRequest.Builder.() -> Unit): DisassociateWirelessGatewayFromThingResponse = disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.Builder().apply(block).build())

/**
 * Gets information about a destination.
 */
public suspend inline fun IotWirelessClient.getDestination(crossinline block: GetDestinationRequest.Builder.() -> Unit): GetDestinationResponse = getDestination(GetDestinationRequest.Builder().apply(block).build())

/**
 * Gets information about a device profile.
 */
public suspend inline fun IotWirelessClient.getDeviceProfile(crossinline block: GetDeviceProfileRequest.Builder.() -> Unit): GetDeviceProfileResponse = getDeviceProfile(GetDeviceProfileRequest.Builder().apply(block).build())

/**
 * Get the event configuration based on resource types.
 */
public suspend inline fun IotWirelessClient.getEventConfigurationByResourceTypes(crossinline block: GetEventConfigurationByResourceTypesRequest.Builder.() -> Unit): GetEventConfigurationByResourceTypesResponse = getEventConfigurationByResourceTypes(GetEventConfigurationByResourceTypesRequest.Builder().apply(block).build())

/**
 * Gets information about a FUOTA task.
 */
public suspend inline fun IotWirelessClient.getFuotaTask(crossinline block: GetFuotaTaskRequest.Builder.() -> Unit): GetFuotaTaskResponse = getFuotaTask(GetFuotaTaskRequest.Builder().apply(block).build())

/**
 * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
 */
public suspend inline fun IotWirelessClient.getLogLevelsByResourceTypes(crossinline block: GetLogLevelsByResourceTypesRequest.Builder.() -> Unit): GetLogLevelsByResourceTypesResponse = getLogLevelsByResourceTypes(GetLogLevelsByResourceTypesRequest.Builder().apply(block).build())

/**
 * Gets information about a multicast group.
 */
public suspend inline fun IotWirelessClient.getMulticastGroup(crossinline block: GetMulticastGroupRequest.Builder.() -> Unit): GetMulticastGroupResponse = getMulticastGroup(GetMulticastGroupRequest.Builder().apply(block).build())

/**
 * Gets information about a multicast group session.
 */
public suspend inline fun IotWirelessClient.getMulticastGroupSession(crossinline block: GetMulticastGroupSessionRequest.Builder.() -> Unit): GetMulticastGroupSessionResponse = getMulticastGroupSession(GetMulticastGroupSessionRequest.Builder().apply(block).build())

/**
 * Get network analyzer configuration.
 */
public suspend inline fun IotWirelessClient.getNetworkAnalyzerConfiguration(crossinline block: GetNetworkAnalyzerConfigurationRequest.Builder.() -> Unit): GetNetworkAnalyzerConfigurationResponse = getNetworkAnalyzerConfiguration(GetNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
 */
public suspend inline fun IotWirelessClient.getPartnerAccount(crossinline block: GetPartnerAccountRequest.Builder.() -> Unit): GetPartnerAccountResponse = getPartnerAccount(GetPartnerAccountRequest.Builder().apply(block).build())

/**
 * Get the position information for a given resource.
 */
public suspend inline fun IotWirelessClient.getPosition(crossinline block: GetPositionRequest.Builder.() -> Unit): GetPositionResponse = getPosition(GetPositionRequest.Builder().apply(block).build())

/**
 * Get position configuration for a given resource.
 */
public suspend inline fun IotWirelessClient.getPositionConfiguration(crossinline block: GetPositionConfigurationRequest.Builder.() -> Unit): GetPositionConfigurationResponse = getPositionConfiguration(GetPositionConfigurationRequest.Builder().apply(block).build())

/**
 * Get the event configuration for a particular resource identifier.
 */
public suspend inline fun IotWirelessClient.getResourceEventConfiguration(crossinline block: GetResourceEventConfigurationRequest.Builder.() -> Unit): GetResourceEventConfigurationResponse = getResourceEventConfiguration(GetResourceEventConfigurationRequest.Builder().apply(block).build())

/**
 * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
 */
public suspend inline fun IotWirelessClient.getResourceLogLevel(crossinline block: GetResourceLogLevelRequest.Builder.() -> Unit): GetResourceLogLevelResponse = getResourceLogLevel(GetResourceLogLevelRequest.Builder().apply(block).build())

/**
 * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
 */
public suspend inline fun IotWirelessClient.getServiceEndpoint(crossinline block: GetServiceEndpointRequest.Builder.() -> Unit): GetServiceEndpointResponse = getServiceEndpoint(GetServiceEndpointRequest.Builder().apply(block).build())

/**
 * Gets information about a service profile.
 */
public suspend inline fun IotWirelessClient.getServiceProfile(crossinline block: GetServiceProfileRequest.Builder.() -> Unit): GetServiceProfileResponse = getServiceProfile(GetServiceProfileRequest.Builder().apply(block).build())

/**
 * Gets information about a wireless device.
 */
public suspend inline fun IotWirelessClient.getWirelessDevice(crossinline block: GetWirelessDeviceRequest.Builder.() -> Unit): GetWirelessDeviceResponse = getWirelessDevice(GetWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Gets operating information about a wireless device.
 */
public suspend inline fun IotWirelessClient.getWirelessDeviceStatistics(crossinline block: GetWirelessDeviceStatisticsRequest.Builder.() -> Unit): GetWirelessDeviceStatisticsResponse = getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.Builder().apply(block).build())

/**
 * Gets information about a wireless gateway.
 */
public suspend inline fun IotWirelessClient.getWirelessGateway(crossinline block: GetWirelessGatewayRequest.Builder.() -> Unit): GetWirelessGatewayResponse = getWirelessGateway(GetWirelessGatewayRequest.Builder().apply(block).build())

/**
 * Gets the ID of the certificate that is currently associated with a wireless gateway.
 */
public suspend inline fun IotWirelessClient.getWirelessGatewayCertificate(crossinline block: GetWirelessGatewayCertificateRequest.Builder.() -> Unit): GetWirelessGatewayCertificateResponse = getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.Builder().apply(block).build())

/**
 * Gets the firmware version and other information about a wireless gateway.
 */
public suspend inline fun IotWirelessClient.getWirelessGatewayFirmwareInformation(crossinline block: GetWirelessGatewayFirmwareInformationRequest.Builder.() -> Unit): GetWirelessGatewayFirmwareInformationResponse = getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.Builder().apply(block).build())

/**
 * Gets operating information about a wireless gateway.
 */
public suspend inline fun IotWirelessClient.getWirelessGatewayStatistics(crossinline block: GetWirelessGatewayStatisticsRequest.Builder.() -> Unit): GetWirelessGatewayStatisticsResponse = getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.Builder().apply(block).build())

/**
 * Gets information about a wireless gateway task.
 */
public suspend inline fun IotWirelessClient.getWirelessGatewayTask(crossinline block: GetWirelessGatewayTaskRequest.Builder.() -> Unit): GetWirelessGatewayTaskResponse = getWirelessGatewayTask(GetWirelessGatewayTaskRequest.Builder().apply(block).build())

/**
 * Gets information about a wireless gateway task definition.
 */
public suspend inline fun IotWirelessClient.getWirelessGatewayTaskDefinition(crossinline block: GetWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit): GetWirelessGatewayTaskDefinitionResponse = getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Lists the destinations registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listDestinations(crossinline block: ListDestinationsRequest.Builder.() -> Unit): ListDestinationsResponse = listDestinations(ListDestinationsRequest.Builder().apply(block).build())

/**
 * Lists the device profiles registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listDeviceProfiles(crossinline block: ListDeviceProfilesRequest.Builder.() -> Unit): ListDeviceProfilesResponse = listDeviceProfiles(ListDeviceProfilesRequest.Builder().apply(block).build())

/**
 * List event configurations where at least one event topic has been enabled.
 */
public suspend inline fun IotWirelessClient.listEventConfigurations(crossinline block: ListEventConfigurationsRequest.Builder.() -> Unit): ListEventConfigurationsResponse = listEventConfigurations(ListEventConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the FUOTA tasks registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listFuotaTasks(crossinline block: ListFuotaTasksRequest.Builder.() -> Unit): ListFuotaTasksResponse = listFuotaTasks(ListFuotaTasksRequest.Builder().apply(block).build())

/**
 * Lists the multicast groups registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listMulticastGroups(crossinline block: ListMulticastGroupsRequest.Builder.() -> Unit): ListMulticastGroupsResponse = listMulticastGroups(ListMulticastGroupsRequest.Builder().apply(block).build())

/**
 * List all multicast groups associated with a fuota task.
 */
public suspend inline fun IotWirelessClient.listMulticastGroupsByFuotaTask(crossinline block: ListMulticastGroupsByFuotaTaskRequest.Builder.() -> Unit): ListMulticastGroupsByFuotaTaskResponse = listMulticastGroupsByFuotaTask(ListMulticastGroupsByFuotaTaskRequest.Builder().apply(block).build())

/**
 * Lists the network analyzer configurations.
 */
public suspend inline fun IotWirelessClient.listNetworkAnalyzerConfigurations(crossinline block: ListNetworkAnalyzerConfigurationsRequest.Builder.() -> Unit): ListNetworkAnalyzerConfigurationsResponse = listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the partner accounts associated with your AWS account.
 */
public suspend inline fun IotWirelessClient.listPartnerAccounts(crossinline block: ListPartnerAccountsRequest.Builder.() -> Unit): ListPartnerAccountsResponse = listPartnerAccounts(ListPartnerAccountsRequest.Builder().apply(block).build())

/**
 * List position configurations for a given resource, such as positioning solvers.
 */
public suspend inline fun IotWirelessClient.listPositionConfigurations(crossinline block: ListPositionConfigurationsRequest.Builder.() -> Unit): ListPositionConfigurationsResponse = listPositionConfigurations(ListPositionConfigurationsRequest.Builder().apply(block).build())

/**
 * List queued messages in the downlink queue.
 */
public suspend inline fun IotWirelessClient.listQueuedMessages(crossinline block: ListQueuedMessagesRequest.Builder.() -> Unit): ListQueuedMessagesResponse = listQueuedMessages(ListQueuedMessagesRequest.Builder().apply(block).build())

/**
 * Lists the service profiles registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listServiceProfiles(crossinline block: ListServiceProfilesRequest.Builder.() -> Unit): ListServiceProfilesResponse = listServiceProfiles(ListServiceProfilesRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) you have assigned to the resource.
 */
public suspend inline fun IotWirelessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the wireless devices registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listWirelessDevices(crossinline block: ListWirelessDevicesRequest.Builder.() -> Unit): ListWirelessDevicesResponse = listWirelessDevices(ListWirelessDevicesRequest.Builder().apply(block).build())

/**
 * List the wireless gateway tasks definitions registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listWirelessGatewayTaskDefinitions(crossinline block: ListWirelessGatewayTaskDefinitionsRequest.Builder.() -> Unit): ListWirelessGatewayTaskDefinitionsResponse = listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists the wireless gateways registered to your AWS account.
 */
public suspend inline fun IotWirelessClient.listWirelessGateways(crossinline block: ListWirelessGatewaysRequest.Builder.() -> Unit): ListWirelessGatewaysResponse = listWirelessGateways(ListWirelessGatewaysRequest.Builder().apply(block).build())

/**
 * Put position configuration for a given resource.
 */
public suspend inline fun IotWirelessClient.putPositionConfiguration(crossinline block: PutPositionConfigurationRequest.Builder.() -> Unit): PutPositionConfigurationResponse = putPositionConfiguration(PutPositionConfigurationRequest.Builder().apply(block).build())

/**
 * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
 */
public suspend inline fun IotWirelessClient.putResourceLogLevel(crossinline block: PutResourceLogLevelRequest.Builder.() -> Unit): PutResourceLogLevelResponse = putResourceLogLevel(PutResourceLogLevelRequest.Builder().apply(block).build())

/**
 * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
 */
public suspend inline fun IotWirelessClient.resetAllResourceLogLevels(crossinline block: ResetAllResourceLogLevelsRequest.Builder.() -> Unit): ResetAllResourceLogLevelsResponse = resetAllResourceLogLevels(ResetAllResourceLogLevelsRequest.Builder().apply(block).build())

/**
 * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
 */
public suspend inline fun IotWirelessClient.resetResourceLogLevel(crossinline block: ResetResourceLogLevelRequest.Builder.() -> Unit): ResetResourceLogLevelResponse = resetResourceLogLevel(ResetResourceLogLevelRequest.Builder().apply(block).build())

/**
 * Sends the specified data to a multicast group.
 */
public suspend inline fun IotWirelessClient.sendDataToMulticastGroup(crossinline block: SendDataToMulticastGroupRequest.Builder.() -> Unit): SendDataToMulticastGroupResponse = sendDataToMulticastGroup(SendDataToMulticastGroupRequest.Builder().apply(block).build())

/**
 * Sends a decrypted application data frame to a device.
 */
public suspend inline fun IotWirelessClient.sendDataToWirelessDevice(crossinline block: SendDataToWirelessDeviceRequest.Builder.() -> Unit): SendDataToWirelessDeviceResponse = sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Starts a bulk association of all qualifying wireless devices with a multicast group.
 */
public suspend inline fun IotWirelessClient.startBulkAssociateWirelessDeviceWithMulticastGroup(crossinline block: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder.() -> Unit): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse = startBulkAssociateWirelessDeviceWithMulticastGroup(StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder().apply(block).build())

/**
 * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
 */
public suspend inline fun IotWirelessClient.startBulkDisassociateWirelessDeviceFromMulticastGroup(crossinline block: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder.() -> Unit): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse = startBulkDisassociateWirelessDeviceFromMulticastGroup(StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder().apply(block).build())

/**
 * Starts a FUOTA task.
 */
public suspend inline fun IotWirelessClient.startFuotaTask(crossinline block: StartFuotaTaskRequest.Builder.() -> Unit): StartFuotaTaskResponse = startFuotaTask(StartFuotaTaskRequest.Builder().apply(block).build())

/**
 * Starts a multicast group session.
 */
public suspend inline fun IotWirelessClient.startMulticastGroupSession(crossinline block: StartMulticastGroupSessionRequest.Builder.() -> Unit): StartMulticastGroupSessionResponse = startMulticastGroupSession(StartMulticastGroupSessionRequest.Builder().apply(block).build())

/**
 * Adds a tag to a resource.
 */
public suspend inline fun IotWirelessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Simulates a provisioned device by sending an uplink data payload of `Hello`.
 */
public suspend inline fun IotWirelessClient.testWirelessDevice(crossinline block: TestWirelessDeviceRequest.Builder.() -> Unit): TestWirelessDeviceResponse = testWirelessDevice(TestWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a resource.
 */
public suspend inline fun IotWirelessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates properties of a destination.
 */
public suspend inline fun IotWirelessClient.updateDestination(crossinline block: UpdateDestinationRequest.Builder.() -> Unit): UpdateDestinationResponse = updateDestination(UpdateDestinationRequest.Builder().apply(block).build())

/**
 * Update the event configuration based on resource types.
 */
public suspend inline fun IotWirelessClient.updateEventConfigurationByResourceTypes(crossinline block: UpdateEventConfigurationByResourceTypesRequest.Builder.() -> Unit): UpdateEventConfigurationByResourceTypesResponse = updateEventConfigurationByResourceTypes(UpdateEventConfigurationByResourceTypesRequest.Builder().apply(block).build())

/**
 * Updates properties of a FUOTA task.
 */
public suspend inline fun IotWirelessClient.updateFuotaTask(crossinline block: UpdateFuotaTaskRequest.Builder.() -> Unit): UpdateFuotaTaskResponse = updateFuotaTask(UpdateFuotaTaskRequest.Builder().apply(block).build())

/**
 * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
 */
public suspend inline fun IotWirelessClient.updateLogLevelsByResourceTypes(crossinline block: UpdateLogLevelsByResourceTypesRequest.Builder.() -> Unit): UpdateLogLevelsByResourceTypesResponse = updateLogLevelsByResourceTypes(UpdateLogLevelsByResourceTypesRequest.Builder().apply(block).build())

/**
 * Updates properties of a multicast group session.
 */
public suspend inline fun IotWirelessClient.updateMulticastGroup(crossinline block: UpdateMulticastGroupRequest.Builder.() -> Unit): UpdateMulticastGroupResponse = updateMulticastGroup(UpdateMulticastGroupRequest.Builder().apply(block).build())

/**
 * Update network analyzer configuration.
 */
public suspend inline fun IotWirelessClient.updateNetworkAnalyzerConfiguration(crossinline block: UpdateNetworkAnalyzerConfigurationRequest.Builder.() -> Unit): UpdateNetworkAnalyzerConfigurationResponse = updateNetworkAnalyzerConfiguration(UpdateNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

/**
 * Updates properties of a partner account.
 */
public suspend inline fun IotWirelessClient.updatePartnerAccount(crossinline block: UpdatePartnerAccountRequest.Builder.() -> Unit): UpdatePartnerAccountResponse = updatePartnerAccount(UpdatePartnerAccountRequest.Builder().apply(block).build())

/**
 * Update the position information of a resource.
 */
public suspend inline fun IotWirelessClient.updatePosition(crossinline block: UpdatePositionRequest.Builder.() -> Unit): UpdatePositionResponse = updatePosition(UpdatePositionRequest.Builder().apply(block).build())

/**
 * Update the event configuration for a particular resource identifier.
 */
public suspend inline fun IotWirelessClient.updateResourceEventConfiguration(crossinline block: UpdateResourceEventConfigurationRequest.Builder.() -> Unit): UpdateResourceEventConfigurationResponse = updateResourceEventConfiguration(UpdateResourceEventConfigurationRequest.Builder().apply(block).build())

/**
 * Updates properties of a wireless device.
 */
public suspend inline fun IotWirelessClient.updateWirelessDevice(crossinline block: UpdateWirelessDeviceRequest.Builder.() -> Unit): UpdateWirelessDeviceResponse = updateWirelessDevice(UpdateWirelessDeviceRequest.Builder().apply(block).build())

/**
 * Updates properties of a wireless gateway.
 */
public suspend inline fun IotWirelessClient.updateWirelessGateway(crossinline block: UpdateWirelessGatewayRequest.Builder.() -> Unit): UpdateWirelessGatewayResponse = updateWirelessGateway(UpdateWirelessGatewayRequest.Builder().apply(block).build())
