// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotthingsgraph.model.IoTThingsGraphException
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchSystemInstancesOperationDeserializer: HttpDeserialize<SearchSystemInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchSystemInstancesResponse {
        if (!response.status.isSuccess()) {
            throwSearchSystemInstancesError(context, response)
        }
        val builder = SearchSystemInstancesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchSystemInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchSystemInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTThingsGraphException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTThingsGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchSystemInstancesOperationBody(builder: SearchSystemInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("summaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SUMMARIES_DESCRIPTOR.index -> builder.summaries =
                    deserializer.deserializeList(SUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<SystemInstanceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSystemInstanceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
