// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.IoTThingsGraphException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteNamespaceOperationDeserializer: HttpDeserialize<DeleteNamespaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteNamespaceResponse {
        if (!response.status.isSuccess()) {
            throwDeleteNamespaceError(context, response)
        }
        val builder = DeleteNamespaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteNamespaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteNamespaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTThingsGraphException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTThingsGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteNamespaceOperationBody(builder: DeleteNamespaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAMESPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceArn"))
    val NAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAMESPACEARN_DESCRIPTOR)
        field(NAMESPACENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAMESPACEARN_DESCRIPTOR.index -> builder.namespaceArn = deserializeString()
                NAMESPACENAME_DESCRIPTOR.index -> builder.namespaceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
