// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.paginators

import aws.sdk.kotlin.services.iotthingsgraph.IoTThingsGraphClient
import aws.sdk.kotlin.services.iotthingsgraph.model.EntityDescription
import aws.sdk.kotlin.services.iotthingsgraph.model.FlowExecutionMessage
import aws.sdk.kotlin.services.iotthingsgraph.model.FlowExecutionSummary
import aws.sdk.kotlin.services.iotthingsgraph.model.FlowTemplateSummary
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary
import aws.sdk.kotlin.services.iotthingsgraph.model.SystemTemplateSummary
import aws.sdk.kotlin.services.iotthingsgraph.model.Tag
import aws.sdk.kotlin.services.iotthingsgraph.model.Thing
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetFlowTemplateRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFlowTemplateRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFlowTemplateRevisionsResponse]
 */
public fun IoTThingsGraphClient.getFlowTemplateRevisionsPaginated(initialRequest: GetFlowTemplateRevisionsRequest): Flow<GetFlowTemplateRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFlowTemplateRevisionsPaginated.getFlowTemplateRevisions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetFlowTemplateRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFlowTemplateRevisionsResponse]
 */
public fun IoTThingsGraphClient.getFlowTemplateRevisionsPaginated(block: GetFlowTemplateRevisionsRequest.Builder.() -> Unit): Flow<GetFlowTemplateRevisionsResponse> =
    getFlowTemplateRevisionsPaginated(GetFlowTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFlowTemplateRevisionsPaginated]
 * to access the nested member [FlowTemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FlowTemplateSummary]
 */
@JvmName("getFlowTemplateRevisionsResponseFlowTemplateSummary")
public fun Flow<GetFlowTemplateRevisionsResponse>.summaries(): Flow<FlowTemplateSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetSystemTemplateRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSystemTemplateRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSystemTemplateRevisionsResponse]
 */
public fun IoTThingsGraphClient.getSystemTemplateRevisionsPaginated(initialRequest: GetSystemTemplateRevisionsRequest): Flow<GetSystemTemplateRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSystemTemplateRevisionsPaginated.getSystemTemplateRevisions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSystemTemplateRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSystemTemplateRevisionsResponse]
 */
public fun IoTThingsGraphClient.getSystemTemplateRevisionsPaginated(block: GetSystemTemplateRevisionsRequest.Builder.() -> Unit): Flow<GetSystemTemplateRevisionsResponse> =
    getSystemTemplateRevisionsPaginated(GetSystemTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getSystemTemplateRevisionsPaginated]
 * to access the nested member [SystemTemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SystemTemplateSummary]
 */
@JvmName("getSystemTemplateRevisionsResponseSystemTemplateSummary")
public fun Flow<GetSystemTemplateRevisionsResponse>.summaries(): Flow<SystemTemplateSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFlowExecutionMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFlowExecutionMessagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowExecutionMessagesResponse]
 */
public fun IoTThingsGraphClient.listFlowExecutionMessagesPaginated(initialRequest: ListFlowExecutionMessagesRequest): Flow<ListFlowExecutionMessagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFlowExecutionMessagesPaginated.listFlowExecutionMessages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFlowExecutionMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowExecutionMessagesResponse]
 */
public fun IoTThingsGraphClient.listFlowExecutionMessagesPaginated(block: ListFlowExecutionMessagesRequest.Builder.() -> Unit): Flow<ListFlowExecutionMessagesResponse> =
    listFlowExecutionMessagesPaginated(ListFlowExecutionMessagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFlowExecutionMessagesPaginated]
 * to access the nested member [FlowExecutionMessage]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FlowExecutionMessage]
 */
@JvmName("listFlowExecutionMessagesResponseFlowExecutionMessage")
public fun Flow<ListFlowExecutionMessagesResponse>.messages(): Flow<FlowExecutionMessage> =
    transform() { response ->
        response.messages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun IoTThingsGraphClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun IoTThingsGraphClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchEntitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchEntitiesResponse]
 */
public fun IoTThingsGraphClient.searchEntitiesPaginated(initialRequest: SearchEntitiesRequest): Flow<SearchEntitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchEntitiesPaginated.searchEntities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchEntitiesResponse]
 */
public fun IoTThingsGraphClient.searchEntitiesPaginated(block: SearchEntitiesRequest.Builder.() -> Unit): Flow<SearchEntitiesResponse> =
    searchEntitiesPaginated(SearchEntitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchEntitiesPaginated]
 * to access the nested member [EntityDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EntityDescription]
 */
@JvmName("searchEntitiesResponseEntityDescription")
public fun Flow<SearchEntitiesResponse>.descriptions(): Flow<EntityDescription> =
    transform() { response ->
        response.descriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchFlowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchFlowExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchFlowExecutionsResponse]
 */
public fun IoTThingsGraphClient.searchFlowExecutionsPaginated(initialRequest: SearchFlowExecutionsRequest): Flow<SearchFlowExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchFlowExecutionsPaginated.searchFlowExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchFlowExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchFlowExecutionsResponse]
 */
public fun IoTThingsGraphClient.searchFlowExecutionsPaginated(block: SearchFlowExecutionsRequest.Builder.() -> Unit): Flow<SearchFlowExecutionsResponse> =
    searchFlowExecutionsPaginated(SearchFlowExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchFlowExecutionsPaginated]
 * to access the nested member [FlowExecutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FlowExecutionSummary]
 */
@JvmName("searchFlowExecutionsResponseFlowExecutionSummary")
public fun Flow<SearchFlowExecutionsResponse>.summaries(): Flow<FlowExecutionSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchFlowTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchFlowTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchFlowTemplatesResponse]
 */
public fun IoTThingsGraphClient.searchFlowTemplatesPaginated(initialRequest: SearchFlowTemplatesRequest): Flow<SearchFlowTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchFlowTemplatesPaginated.searchFlowTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchFlowTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchFlowTemplatesResponse]
 */
public fun IoTThingsGraphClient.searchFlowTemplatesPaginated(block: SearchFlowTemplatesRequest.Builder.() -> Unit): Flow<SearchFlowTemplatesResponse> =
    searchFlowTemplatesPaginated(SearchFlowTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchFlowTemplatesPaginated]
 * to access the nested member [FlowTemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FlowTemplateSummary]
 */
@JvmName("searchFlowTemplatesResponseFlowTemplateSummary")
public fun Flow<SearchFlowTemplatesResponse>.summaries(): Flow<FlowTemplateSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchSystemInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchSystemInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSystemInstancesResponse]
 */
public fun IoTThingsGraphClient.searchSystemInstancesPaginated(initialRequest: SearchSystemInstancesRequest): Flow<SearchSystemInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchSystemInstancesPaginated.searchSystemInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchSystemInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSystemInstancesResponse]
 */
public fun IoTThingsGraphClient.searchSystemInstancesPaginated(block: SearchSystemInstancesRequest.Builder.() -> Unit): Flow<SearchSystemInstancesResponse> =
    searchSystemInstancesPaginated(SearchSystemInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchSystemInstancesPaginated]
 * to access the nested member [SystemInstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SystemInstanceSummary]
 */
@JvmName("searchSystemInstancesResponseSystemInstanceSummary")
public fun Flow<SearchSystemInstancesResponse>.summaries(): Flow<SystemInstanceSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchSystemTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchSystemTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSystemTemplatesResponse]
 */
public fun IoTThingsGraphClient.searchSystemTemplatesPaginated(initialRequest: SearchSystemTemplatesRequest): Flow<SearchSystemTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchSystemTemplatesPaginated.searchSystemTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchSystemTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSystemTemplatesResponse]
 */
public fun IoTThingsGraphClient.searchSystemTemplatesPaginated(block: SearchSystemTemplatesRequest.Builder.() -> Unit): Flow<SearchSystemTemplatesResponse> =
    searchSystemTemplatesPaginated(SearchSystemTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchSystemTemplatesPaginated]
 * to access the nested member [SystemTemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SystemTemplateSummary]
 */
@JvmName("searchSystemTemplatesResponseSystemTemplateSummary")
public fun Flow<SearchSystemTemplatesResponse>.summaries(): Flow<SystemTemplateSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchThingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchThingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchThingsResponse]
 */
public fun IoTThingsGraphClient.searchThingsPaginated(initialRequest: SearchThingsRequest): Flow<SearchThingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchThingsPaginated.searchThings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchThingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchThingsResponse]
 */
public fun IoTThingsGraphClient.searchThingsPaginated(block: SearchThingsRequest.Builder.() -> Unit): Flow<SearchThingsResponse> =
    searchThingsPaginated(SearchThingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchThingsPaginated]
 * to access the nested member [Thing]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Thing]
 */
@JvmName("searchThingsResponseThing")
public fun Flow<SearchThingsResponse>.things(): Flow<Thing> =
    transform() { response ->
        response.things?.forEach {
            emit(it)
        }
    }
