// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotthingsgraph.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotthingsgraph.model.*
import aws.sdk.kotlin.services.iotthingsgraph.model.AssociateEntityToThingRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.AssociateEntityToThingResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeploySystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeploySystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DescribeNamespaceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DescribeNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DissociateEntityFromThingRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DissociateEntityFromThingResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetEntitiesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetEntitiesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetUploadStatusRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetUploadStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.TagResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.TagResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UndeploySystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UndeploySystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UploadEntityDefinitionsResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS IoT Things Graph
 * AWS IoT Things Graph provides an integrated set of tools that enable developers to connect devices and services that use different standards, such as units of measure and communication protocols. AWS IoT Things Graph makes it possible to build IoT applications with little to no code by connecting devices and services and defining how they interact at an abstract level.
 *
 * For more information about how AWS IoT Things Graph works, see the [User Guide](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-whatis.html).
 *
 * The AWS IoT Things Graph service is discontinued.
 */
public interface IoTThingsGraphClient : SdkClient {

    override val serviceName: String
        get() = "IoTThingsGraph"
    /**
     * IoTThingsGraphClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IoTThingsGraphClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTThingsGraphClient(config)
        }

        public operator fun invoke(config: Config): IoTThingsGraphClient = DefaultIoTThingsGraphClient(config)

        /**
         * Construct a [IoTThingsGraphClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTThingsGraphClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIoTThingsGraphClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun associateEntityToThing(input: AssociateEntityToThingRequest): AssociateEntityToThingResponse

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createFlowTemplate(input: CreateFlowTemplateRequest): CreateFlowTemplateResponse

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createSystemInstance(input: CreateSystemInstanceRequest): CreateSystemInstanceResponse

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createSystemTemplate(input: CreateSystemTemplateRequest): CreateSystemTemplateResponse

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteFlowTemplate(input: DeleteFlowTemplateRequest): DeleteFlowTemplateResponse

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action. This action takes no request parameters.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest = DeleteNamespaceRequest {}): DeleteNamespaceResponse

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteSystemInstance(input: DeleteSystemInstanceRequest = DeleteSystemInstanceRequest {}): DeleteSystemInstanceResponse

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteSystemTemplate(input: DeleteSystemTemplateRequest): DeleteSystemTemplateResponse

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deploySystemInstance(input: DeploySystemInstanceRequest = DeploySystemInstanceRequest {}): DeploySystemInstanceResponse

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deprecateFlowTemplate(input: DeprecateFlowTemplateRequest): DeprecateFlowTemplateResponse

    /**
     * Deprecates the specified system.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deprecateSystemTemplate(input: DeprecateSystemTemplateRequest): DeprecateSystemTemplateResponse

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeNamespace(input: DescribeNamespaceRequest = DescribeNamespaceRequest {}): DescribeNamespaceResponse

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun dissociateEntityFromThing(input: DissociateEntityFromThingRequest): DissociateEntityFromThingResponse

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getEntities(input: GetEntitiesRequest): GetEntitiesResponse

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getFlowTemplate(input: GetFlowTemplateRequest): GetFlowTemplateResponse

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getFlowTemplateRevisions(input: GetFlowTemplateRevisionsRequest): GetFlowTemplateRevisionsResponse

    /**
     * Gets the status of a namespace deletion task.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getNamespaceDeletionStatus(input: GetNamespaceDeletionStatusRequest = GetNamespaceDeletionStatusRequest {}): GetNamespaceDeletionStatusResponse

    /**
     * Gets a system instance.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getSystemInstance(input: GetSystemInstanceRequest): GetSystemInstanceResponse

    /**
     * Gets a system.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getSystemTemplate(input: GetSystemTemplateRequest): GetSystemTemplateResponse

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getSystemTemplateRevisions(input: GetSystemTemplateRevisionsRequest): GetSystemTemplateRevisionsResponse

    /**
     * Gets the status of the specified upload.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getUploadStatus(input: GetUploadStatusRequest): GetUploadStatusResponse

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listFlowExecutionMessages(input: ListFlowExecutionMessagesRequest): ListFlowExecutionMessagesResponse

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchEntities(input: SearchEntitiesRequest): SearchEntitiesResponse

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchFlowExecutions(input: SearchFlowExecutionsRequest): SearchFlowExecutionsResponse

    /**
     * Searches for summary information about workflows.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchFlowTemplates(input: SearchFlowTemplatesRequest = SearchFlowTemplatesRequest {}): SearchFlowTemplatesResponse

    /**
     * Searches for system instances in the user's account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchSystemInstances(input: SearchSystemInstancesRequest = SearchSystemInstancesRequest {}): SearchSystemInstancesResponse

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchSystemTemplates(input: SearchSystemTemplatesRequest = SearchSystemTemplatesRequest {}): SearchSystemTemplatesResponse

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun searchThings(input: SearchThingsRequest): SearchThingsResponse

    /**
     * Creates a tag for the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun undeploySystemInstance(input: UndeploySystemInstanceRequest = UndeploySystemInstanceRequest {}): UndeploySystemInstanceResponse

    /**
     * Removes a tag from the specified resource.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateFlowTemplate(input: UpdateFlowTemplateRequest): UpdateFlowTemplateResponse

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun updateSystemTemplate(input: UpdateSystemTemplateRequest): UpdateSystemTemplateResponse

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun uploadEntityDefinitions(input: UploadEntityDefinitionsRequest = UploadEntityDefinitionsRequest {}): UploadEntityDefinitionsResponse
}

/**
 * Associates a device with a concrete thing that is in the user's registry.
 *
 * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.associateEntityToThing(crossinline block: AssociateEntityToThingRequest.Builder.() -> Unit): AssociateEntityToThingResponse = associateEntityToThing(AssociateEntityToThingRequest.Builder().apply(block).build())

/**
 * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.createFlowTemplate(crossinline block: CreateFlowTemplateRequest.Builder.() -> Unit): CreateFlowTemplateResponse = createFlowTemplate(CreateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Creates a system instance.
 *
 * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
 *
 * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
 *
 * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
 *
 * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.createSystemInstance(crossinline block: CreateSystemInstanceRequest.Builder.() -> Unit): CreateSystemInstanceResponse = createSystemInstance(CreateSystemInstanceRequest.Builder().apply(block).build())

/**
 * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.createSystemTemplate(crossinline block: CreateSystemTemplateRequest.Builder.() -> Unit): CreateSystemTemplateResponse = createSystemTemplate(CreateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deleteFlowTemplate(crossinline block: DeleteFlowTemplateRequest.Builder.() -> Unit): DeleteFlowTemplateResponse = deleteFlowTemplate(DeleteFlowTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action. This action takes no request parameters.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
 *
 * Users can create a new system instance that has the same ID as a deleted system instance.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deleteSystemInstance(crossinline block: DeleteSystemInstanceRequest.Builder.() -> Unit): DeleteSystemInstanceResponse = deleteSystemInstance(DeleteSystemInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deleteSystemTemplate(crossinline block: DeleteSystemTemplateRequest.Builder.() -> Unit): DeleteSystemTemplateResponse = deleteSystemTemplate(DeleteSystemTemplateRequest.Builder().apply(block).build())

/**
 * **Greengrass and Cloud Deployments**
 *
 * Deploys the system instance to the target specified in `CreateSystemInstance`.
 *
 * **Greengrass Deployments**
 *
 * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
 *
 * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
 *
 * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deploySystemInstance(crossinline block: DeploySystemInstanceRequest.Builder.() -> Unit): DeploySystemInstanceResponse = deploySystemInstance(DeploySystemInstanceRequest.Builder().apply(block).build())

/**
 * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deprecateFlowTemplate(crossinline block: DeprecateFlowTemplateRequest.Builder.() -> Unit): DeprecateFlowTemplateResponse = deprecateFlowTemplate(DeprecateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Deprecates the specified system.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.deprecateSystemTemplate(crossinline block: DeprecateSystemTemplateRequest.Builder.() -> Unit): DeprecateSystemTemplateResponse = deprecateSystemTemplate(DeprecateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Gets the latest version of the user's namespace and the public version that it is tracking.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.describeNamespace(crossinline block: DescribeNamespaceRequest.Builder.() -> Unit): DescribeNamespaceResponse = describeNamespace(DescribeNamespaceRequest.Builder().apply(block).build())

/**
 * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.dissociateEntityFromThing(crossinline block: DissociateEntityFromThingRequest.Builder.() -> Unit): DissociateEntityFromThingResponse = dissociateEntityFromThing(DissociateEntityFromThingRequest.Builder().apply(block).build())

/**
 * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
 * + Properties
 * + States
 * + Events
 * + Actions
 * + Capabilities
 * + Mappings
 * + Devices
 * + Device Models
 * + Services
 *
 * This action doesn't return definitions for systems, flows, and deployments.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getEntities(crossinline block: GetEntitiesRequest.Builder.() -> Unit): GetEntitiesResponse = getEntities(GetEntitiesRequest.Builder().apply(block).build())

/**
 * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getFlowTemplate(crossinline block: GetFlowTemplateRequest.Builder.() -> Unit): GetFlowTemplateResponse = getFlowTemplate(GetFlowTemplateRequest.Builder().apply(block).build())

/**
 * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getFlowTemplateRevisions(crossinline block: GetFlowTemplateRevisionsRequest.Builder.() -> Unit): GetFlowTemplateRevisionsResponse = getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * Gets the status of a namespace deletion task.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getNamespaceDeletionStatus(crossinline block: GetNamespaceDeletionStatusRequest.Builder.() -> Unit): GetNamespaceDeletionStatusResponse = getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest.Builder().apply(block).build())

/**
 * Gets a system instance.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getSystemInstance(crossinline block: GetSystemInstanceRequest.Builder.() -> Unit): GetSystemInstanceResponse = getSystemInstance(GetSystemInstanceRequest.Builder().apply(block).build())

/**
 * Gets a system.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getSystemTemplate(crossinline block: GetSystemTemplateRequest.Builder.() -> Unit): GetSystemTemplateResponse = getSystemTemplate(GetSystemTemplateRequest.Builder().apply(block).build())

/**
 * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getSystemTemplateRevisions(crossinline block: GetSystemTemplateRevisionsRequest.Builder.() -> Unit): GetSystemTemplateRevisionsResponse = getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * Gets the status of the specified upload.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.getUploadStatus(crossinline block: GetUploadStatusRequest.Builder.() -> Unit): GetUploadStatusResponse = getUploadStatus(GetUploadStatusRequest.Builder().apply(block).build())

/**
 * Returns a list of objects that contain information about events in a flow execution.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.listFlowExecutionMessages(crossinline block: ListFlowExecutionMessagesRequest.Builder.() -> Unit): ListFlowExecutionMessagesResponse = listFlowExecutionMessages(ListFlowExecutionMessagesRequest.Builder().apply(block).build())

/**
 * Lists all tags on an AWS IoT Things Graph resource.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchEntities(crossinline block: SearchEntitiesRequest.Builder.() -> Unit): SearchEntitiesResponse = searchEntities(SearchEntitiesRequest.Builder().apply(block).build())

/**
 * Searches for AWS IoT Things Graph workflow execution instances.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchFlowExecutions(crossinline block: SearchFlowExecutionsRequest.Builder.() -> Unit): SearchFlowExecutionsResponse = searchFlowExecutions(SearchFlowExecutionsRequest.Builder().apply(block).build())

/**
 * Searches for summary information about workflows.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchFlowTemplates(crossinline block: SearchFlowTemplatesRequest.Builder.() -> Unit): SearchFlowTemplatesResponse = searchFlowTemplates(SearchFlowTemplatesRequest.Builder().apply(block).build())

/**
 * Searches for system instances in the user's account.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchSystemInstances(crossinline block: SearchSystemInstancesRequest.Builder.() -> Unit): SearchSystemInstancesResponse = searchSystemInstances(SearchSystemInstancesRequest.Builder().apply(block).build())

/**
 * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchSystemTemplates(crossinline block: SearchSystemTemplatesRequest.Builder.() -> Unit): SearchSystemTemplatesResponse = searchSystemTemplates(SearchSystemTemplatesRequest.Builder().apply(block).build())

/**
 * Searches for things associated with the specified entity. You can search by both device and device model.
 *
 * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
 *
 * This action searches for exact matches and doesn't perform partial text matching.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.searchThings(crossinline block: SearchThingsRequest.Builder.() -> Unit): SearchThingsResponse = searchThings(SearchThingsRequest.Builder().apply(block).build())

/**
 * Creates a tag for the specified resource.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a system instance from its target (Cloud or Greengrass).
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.undeploySystemInstance(crossinline block: UndeploySystemInstanceRequest.Builder.() -> Unit): UndeploySystemInstanceResponse = undeploySystemInstance(UndeploySystemInstanceRequest.Builder().apply(block).build())

/**
 * Removes a tag from the specified resource.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.updateFlowTemplate(crossinline block: UpdateFlowTemplateRequest.Builder.() -> Unit): UpdateFlowTemplateResponse = updateFlowTemplate(UpdateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.updateSystemTemplate(crossinline block: UpdateSystemTemplateRequest.Builder.() -> Unit): UpdateSystemTemplateResponse = updateSystemTemplate(UpdateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
 *
 * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
 *
 * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
 *
 * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun IoTThingsGraphClient.uploadEntityDefinitions(crossinline block: UploadEntityDefinitionsRequest.Builder.() -> Unit): UploadEntityDefinitionsResponse = uploadEntityDefinitions(UploadEntityDefinitionsRequest.Builder().apply(block).build())
