// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.serde

import aws.sdk.kotlin.services.iotthingsgraph.model.GetUploadStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.IotThingsGraphException
import aws.sdk.kotlin.services.iotthingsgraph.model.UploadStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetUploadStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetUploadStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUploadStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUploadStatusError(context, call, payload)
        }
        val builder = GetUploadStatusResponse.Builder()

        if (payload != null) {
            deserializeGetUploadStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUploadStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotThingsGraphException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotThingsGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUploadStatusOperationBody(builder: GetUploadStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReason"))
    val NAMESPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceArn"))
    val NAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceName"))
    val NAMESPACEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("namespaceVersion"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val UPLOADSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("uploadStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDDATE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(NAMESPACEARN_DESCRIPTOR)
        field(NAMESPACENAME_DESCRIPTOR)
        field(NAMESPACEVERSION_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
        field(UPLOADSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason =
                    deserializer.deserializeList(FAILUREREASON_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAMESPACEARN_DESCRIPTOR.index -> builder.namespaceArn = deserializeString()
                NAMESPACENAME_DESCRIPTOR.index -> builder.namespaceName = deserializeString()
                NAMESPACEVERSION_DESCRIPTOR.index -> builder.namespaceVersion = deserializeLong()
                UPLOADID_DESCRIPTOR.index -> builder.uploadId = deserializeString()
                UPLOADSTATUS_DESCRIPTOR.index -> builder.uploadStatus = deserializeString().let { UploadStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
