// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.serde

import aws.sdk.kotlin.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.IotThingsGraphException
import aws.sdk.kotlin.services.iotthingsgraph.model.NamespaceDeletionStatus
import aws.sdk.kotlin.services.iotthingsgraph.model.NamespaceDeletionStatusErrorCodes
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetNamespaceDeletionStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetNamespaceDeletionStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetNamespaceDeletionStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetNamespaceDeletionStatusError(context, call, payload)
        }
        val builder = GetNamespaceDeletionStatusResponse.Builder()

        if (payload != null) {
            deserializeGetNamespaceDeletionStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetNamespaceDeletionStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotThingsGraphException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotThingsGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetNamespaceDeletionStatusOperationBody(builder: GetNamespaceDeletionStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("errorCode"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val NAMESPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceArn"))
    val NAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORCODE_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(NAMESPACEARN_DESCRIPTOR)
        field(NAMESPACENAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORCODE_DESCRIPTOR.index -> builder.errorCode = deserializeString().let { NamespaceDeletionStatusErrorCodes.fromValue(it) }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                NAMESPACEARN_DESCRIPTOR.index -> builder.namespaceArn = deserializeString()
                NAMESPACENAME_DESCRIPTOR.index -> builder.namespaceName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { NamespaceDeletionStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
