// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotthingsgraph.auth.DefaultIotThingsGraphAuthSchemeProvider
import aws.sdk.kotlin.services.iotthingsgraph.auth.IotThingsGraphAuthSchemeProvider
import aws.sdk.kotlin.services.iotthingsgraph.endpoints.DefaultIotThingsGraphEndpointProvider
import aws.sdk.kotlin.services.iotthingsgraph.endpoints.IotThingsGraphEndpointParameters
import aws.sdk.kotlin.services.iotthingsgraph.endpoints.IotThingsGraphEndpointProvider
import aws.sdk.kotlin.services.iotthingsgraph.model.AssociateEntityToThingRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.AssociateEntityToThingResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeleteSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeploySystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeploySystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DeprecateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DescribeNamespaceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DescribeNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.DissociateEntityFromThingRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.DissociateEntityFromThingResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetEntitiesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetEntitiesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.GetUploadStatusRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.GetUploadStatusResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchEntitiesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowExecutionsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchFlowTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemInstancesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchSystemTemplatesResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.SearchThingsResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.TagResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.TagResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UndeploySystemInstanceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UndeploySystemInstanceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateFlowTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateFlowTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateSystemTemplateRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UpdateSystemTemplateResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
import aws.sdk.kotlin.services.iotthingsgraph.model.UploadEntityDefinitionsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "IoTThingsGraph"
public const val SdkVersion: String = "1.5.34"
public const val ServiceApiVersion: String = "2018-09-06"

/**
 * # AWS IoT Things Graph
 * AWS IoT Things Graph provides an integrated set of tools that enable developers to connect devices and services that use different standards, such as units of measure and communication protocols. AWS IoT Things Graph makes it possible to build IoT applications with little to no code by connecting devices and services and defining how they interact at an abstract level.
 *
 * For more information about how AWS IoT Things Graph works, see the [User Guide](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-whatis.html).
 *
 * The AWS IoT Things Graph service is discontinued.
 */
public interface IotThingsGraphClient : SdkClient {
    /**
     * IotThingsGraphClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotThingsGraphClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotThingsGraph",
                "IOTTHINGSGRAPH",
                "iotthingsgraph",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotThingsGraphClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotThingsGraphClient = DefaultIotThingsGraphClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotThingsGraphEndpointProvider = builder.endpointProvider ?: DefaultIotThingsGraphEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotThingsGraphAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotThingsGraphAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoTThingsGraph"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotThingsGraphEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotThingsGraphAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun associateEntityToThing(input: AssociateEntityToThingRequest): AssociateEntityToThingResponse

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun createFlowTemplate(input: CreateFlowTemplateRequest): CreateFlowTemplateResponse

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun createSystemInstance(input: CreateSystemInstanceRequest): CreateSystemInstanceResponse

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun createSystemTemplate(input: CreateSystemTemplateRequest): CreateSystemTemplateResponse

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deleteFlowTemplate(input: DeleteFlowTemplateRequest): DeleteFlowTemplateResponse

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action. This action takes no request parameters.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest = DeleteNamespaceRequest { }): DeleteNamespaceResponse

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deleteSystemInstance(input: DeleteSystemInstanceRequest = DeleteSystemInstanceRequest { }): DeleteSystemInstanceResponse

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deleteSystemTemplate(input: DeleteSystemTemplateRequest): DeleteSystemTemplateResponse

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deploySystemInstance(input: DeploySystemInstanceRequest = DeploySystemInstanceRequest { }): DeploySystemInstanceResponse

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deprecateFlowTemplate(input: DeprecateFlowTemplateRequest): DeprecateFlowTemplateResponse

    /**
     * Deprecates the specified system.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun deprecateSystemTemplate(input: DeprecateSystemTemplateRequest): DeprecateSystemTemplateResponse

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun describeNamespace(input: DescribeNamespaceRequest = DescribeNamespaceRequest { }): DescribeNamespaceResponse

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun dissociateEntityFromThing(input: DissociateEntityFromThingRequest): DissociateEntityFromThingResponse

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getEntities(input: GetEntitiesRequest): GetEntitiesResponse

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getFlowTemplate(input: GetFlowTemplateRequest): GetFlowTemplateResponse

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getFlowTemplateRevisions(input: GetFlowTemplateRevisionsRequest): GetFlowTemplateRevisionsResponse

    /**
     * Gets the status of a namespace deletion task.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getNamespaceDeletionStatus(input: GetNamespaceDeletionStatusRequest = GetNamespaceDeletionStatusRequest { }): GetNamespaceDeletionStatusResponse

    /**
     * Gets a system instance.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getSystemInstance(input: GetSystemInstanceRequest): GetSystemInstanceResponse

    /**
     * Gets a system.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getSystemTemplate(input: GetSystemTemplateRequest): GetSystemTemplateResponse

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getSystemTemplateRevisions(input: GetSystemTemplateRevisionsRequest): GetSystemTemplateRevisionsResponse

    /**
     * Gets the status of the specified upload.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun getUploadStatus(input: GetUploadStatusRequest): GetUploadStatusResponse

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun listFlowExecutionMessages(input: ListFlowExecutionMessagesRequest): ListFlowExecutionMessagesResponse

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchEntities(input: SearchEntitiesRequest): SearchEntitiesResponse

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchFlowExecutions(input: SearchFlowExecutionsRequest): SearchFlowExecutionsResponse

    /**
     * Searches for summary information about workflows.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchFlowTemplates(input: SearchFlowTemplatesRequest = SearchFlowTemplatesRequest { }): SearchFlowTemplatesResponse

    /**
     * Searches for system instances in the user's account.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchSystemInstances(input: SearchSystemInstancesRequest = SearchSystemInstancesRequest { }): SearchSystemInstancesResponse

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchSystemTemplates(input: SearchSystemTemplatesRequest = SearchSystemTemplatesRequest { }): SearchSystemTemplatesResponse

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun searchThings(input: SearchThingsRequest): SearchThingsResponse

    /**
     * Creates a tag for the specified resource.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun undeploySystemInstance(input: UndeploySystemInstanceRequest = UndeploySystemInstanceRequest { }): UndeploySystemInstanceResponse

    /**
     * Removes a tag from the specified resource.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun updateFlowTemplate(input: UpdateFlowTemplateRequest): UpdateFlowTemplateResponse

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun updateSystemTemplate(input: UpdateSystemTemplateRequest): UpdateSystemTemplateResponse

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    @Deprecated("since: 2022-08-30")
    public suspend fun uploadEntityDefinitions(input: UploadEntityDefinitionsRequest = UploadEntityDefinitionsRequest { }): UploadEntityDefinitionsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotThingsGraphClient.withConfig(block: IotThingsGraphClient.Config.Builder.() -> Unit): IotThingsGraphClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotThingsGraphClient(newConfig)
}

/**
 * Associates a device with a concrete thing that is in the user's registry.
 *
 * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.associateEntityToThing(crossinline block: AssociateEntityToThingRequest.Builder.() -> Unit): AssociateEntityToThingResponse = associateEntityToThing(AssociateEntityToThingRequest.Builder().apply(block).build())

/**
 * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.createFlowTemplate(crossinline block: CreateFlowTemplateRequest.Builder.() -> Unit): CreateFlowTemplateResponse = createFlowTemplate(CreateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Creates a system instance.
 *
 * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
 *
 * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
 *
 * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
 *
 * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.createSystemInstance(crossinline block: CreateSystemInstanceRequest.Builder.() -> Unit): CreateSystemInstanceResponse = createSystemInstance(CreateSystemInstanceRequest.Builder().apply(block).build())

/**
 * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.createSystemTemplate(crossinline block: CreateSystemTemplateRequest.Builder.() -> Unit): CreateSystemTemplateResponse = createSystemTemplate(CreateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deleteFlowTemplate(crossinline block: DeleteFlowTemplateRequest.Builder.() -> Unit): DeleteFlowTemplateResponse = deleteFlowTemplate(DeleteFlowTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action. This action takes no request parameters.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
 *
 * Users can create a new system instance that has the same ID as a deleted system instance.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deleteSystemInstance(crossinline block: DeleteSystemInstanceRequest.Builder.() -> Unit): DeleteSystemInstanceResponse = deleteSystemInstance(DeleteSystemInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deleteSystemTemplate(crossinline block: DeleteSystemTemplateRequest.Builder.() -> Unit): DeleteSystemTemplateResponse = deleteSystemTemplate(DeleteSystemTemplateRequest.Builder().apply(block).build())

/**
 * **Greengrass and Cloud Deployments**
 *
 * Deploys the system instance to the target specified in `CreateSystemInstance`.
 *
 * **Greengrass Deployments**
 *
 * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
 *
 * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
 *
 * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deploySystemInstance(crossinline block: DeploySystemInstanceRequest.Builder.() -> Unit): DeploySystemInstanceResponse = deploySystemInstance(DeploySystemInstanceRequest.Builder().apply(block).build())

/**
 * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deprecateFlowTemplate(crossinline block: DeprecateFlowTemplateRequest.Builder.() -> Unit): DeprecateFlowTemplateResponse = deprecateFlowTemplate(DeprecateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Deprecates the specified system.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.deprecateSystemTemplate(crossinline block: DeprecateSystemTemplateRequest.Builder.() -> Unit): DeprecateSystemTemplateResponse = deprecateSystemTemplate(DeprecateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Gets the latest version of the user's namespace and the public version that it is tracking.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.describeNamespace(crossinline block: DescribeNamespaceRequest.Builder.() -> Unit): DescribeNamespaceResponse = describeNamespace(DescribeNamespaceRequest.Builder().apply(block).build())

/**
 * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.dissociateEntityFromThing(crossinline block: DissociateEntityFromThingRequest.Builder.() -> Unit): DissociateEntityFromThingResponse = dissociateEntityFromThing(DissociateEntityFromThingRequest.Builder().apply(block).build())

/**
 * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
 * + Properties
 * + States
 * + Events
 * + Actions
 * + Capabilities
 * + Mappings
 * + Devices
 * + Device Models
 * + Services
 *
 * This action doesn't return definitions for systems, flows, and deployments.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getEntities(crossinline block: GetEntitiesRequest.Builder.() -> Unit): GetEntitiesResponse = getEntities(GetEntitiesRequest.Builder().apply(block).build())

/**
 * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getFlowTemplate(crossinline block: GetFlowTemplateRequest.Builder.() -> Unit): GetFlowTemplateResponse = getFlowTemplate(GetFlowTemplateRequest.Builder().apply(block).build())

/**
 * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getFlowTemplateRevisions(crossinline block: GetFlowTemplateRevisionsRequest.Builder.() -> Unit): GetFlowTemplateRevisionsResponse = getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * Gets the status of a namespace deletion task.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getNamespaceDeletionStatus(crossinline block: GetNamespaceDeletionStatusRequest.Builder.() -> Unit): GetNamespaceDeletionStatusResponse = getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest.Builder().apply(block).build())

/**
 * Gets a system instance.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getSystemInstance(crossinline block: GetSystemInstanceRequest.Builder.() -> Unit): GetSystemInstanceResponse = getSystemInstance(GetSystemInstanceRequest.Builder().apply(block).build())

/**
 * Gets a system.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getSystemTemplate(crossinline block: GetSystemTemplateRequest.Builder.() -> Unit): GetSystemTemplateResponse = getSystemTemplate(GetSystemTemplateRequest.Builder().apply(block).build())

/**
 * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getSystemTemplateRevisions(crossinline block: GetSystemTemplateRevisionsRequest.Builder.() -> Unit): GetSystemTemplateRevisionsResponse = getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest.Builder().apply(block).build())

/**
 * Gets the status of the specified upload.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.getUploadStatus(crossinline block: GetUploadStatusRequest.Builder.() -> Unit): GetUploadStatusResponse = getUploadStatus(GetUploadStatusRequest.Builder().apply(block).build())

/**
 * Returns a list of objects that contain information about events in a flow execution.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.listFlowExecutionMessages(crossinline block: ListFlowExecutionMessagesRequest.Builder.() -> Unit): ListFlowExecutionMessagesResponse = listFlowExecutionMessages(ListFlowExecutionMessagesRequest.Builder().apply(block).build())

/**
 * Lists all tags on an AWS IoT Things Graph resource.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchEntities(crossinline block: SearchEntitiesRequest.Builder.() -> Unit): SearchEntitiesResponse = searchEntities(SearchEntitiesRequest.Builder().apply(block).build())

/**
 * Searches for AWS IoT Things Graph workflow execution instances.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchFlowExecutions(crossinline block: SearchFlowExecutionsRequest.Builder.() -> Unit): SearchFlowExecutionsResponse = searchFlowExecutions(SearchFlowExecutionsRequest.Builder().apply(block).build())

/**
 * Searches for summary information about workflows.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchFlowTemplates(crossinline block: SearchFlowTemplatesRequest.Builder.() -> Unit): SearchFlowTemplatesResponse = searchFlowTemplates(SearchFlowTemplatesRequest.Builder().apply(block).build())

/**
 * Searches for system instances in the user's account.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchSystemInstances(crossinline block: SearchSystemInstancesRequest.Builder.() -> Unit): SearchSystemInstancesResponse = searchSystemInstances(SearchSystemInstancesRequest.Builder().apply(block).build())

/**
 * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchSystemTemplates(crossinline block: SearchSystemTemplatesRequest.Builder.() -> Unit): SearchSystemTemplatesResponse = searchSystemTemplates(SearchSystemTemplatesRequest.Builder().apply(block).build())

/**
 * Searches for things associated with the specified entity. You can search by both device and device model.
 *
 * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
 *
 * This action searches for exact matches and doesn't perform partial text matching.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.searchThings(crossinline block: SearchThingsRequest.Builder.() -> Unit): SearchThingsResponse = searchThings(SearchThingsRequest.Builder().apply(block).build())

/**
 * Creates a tag for the specified resource.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a system instance from its target (Cloud or Greengrass).
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.undeploySystemInstance(crossinline block: UndeploySystemInstanceRequest.Builder.() -> Unit): UndeploySystemInstanceResponse = undeploySystemInstance(UndeploySystemInstanceRequest.Builder().apply(block).build())

/**
 * Removes a tag from the specified resource.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.updateFlowTemplate(crossinline block: UpdateFlowTemplateRequest.Builder.() -> Unit): UpdateFlowTemplateResponse = updateFlowTemplate(UpdateFlowTemplateRequest.Builder().apply(block).build())

/**
 * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.updateSystemTemplate(crossinline block: UpdateSystemTemplateRequest.Builder.() -> Unit): UpdateSystemTemplateResponse = updateSystemTemplate(UpdateSystemTemplateRequest.Builder().apply(block).build())

/**
 * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
 *
 * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
 *
 * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
 *
 * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
 */
@Deprecated("since: 2022-08-30")
public suspend inline fun IotThingsGraphClient.uploadEntityDefinitions(crossinline block: UploadEntityDefinitionsRequest.Builder.() -> Unit): UploadEntityDefinitionsResponse = uploadEntityDefinitions(UploadEntityDefinitionsRequest.Builder().apply(block).build())
