// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.iotthingsgraph.auth.IotThingsGraphAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.iotthingsgraph.auth.IotThingsGraphIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.iotthingsgraph.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.iotthingsgraph.model.*
import aws.sdk.kotlin.services.iotthingsgraph.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultIotThingsGraphClient(override val config: IotThingsGraphClient.Config) : IotThingsGraphClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IotThingsGraphIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "iotthingsgraph")
        }
        toMap()
    }
    private val authSchemeAdapter = IotThingsGraphAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.iotthingsgraph"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun associateEntityToThing(input: AssociateEntityToThingRequest): AssociateEntityToThingResponse {
        val op = SdkHttpOperation.build<AssociateEntityToThingRequest, AssociateEntityToThingResponse> {
            serializeWith = AssociateEntityToThingOperationSerializer()
            deserializeWith = AssociateEntityToThingOperationDeserializer()
            operationName = "AssociateEntityToThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun createFlowTemplate(input: CreateFlowTemplateRequest): CreateFlowTemplateResponse {
        val op = SdkHttpOperation.build<CreateFlowTemplateRequest, CreateFlowTemplateResponse> {
            serializeWith = CreateFlowTemplateOperationSerializer()
            deserializeWith = CreateFlowTemplateOperationDeserializer()
            operationName = "CreateFlowTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun createSystemInstance(input: CreateSystemInstanceRequest): CreateSystemInstanceResponse {
        val op = SdkHttpOperation.build<CreateSystemInstanceRequest, CreateSystemInstanceResponse> {
            serializeWith = CreateSystemInstanceOperationSerializer()
            deserializeWith = CreateSystemInstanceOperationDeserializer()
            operationName = "CreateSystemInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun createSystemTemplate(input: CreateSystemTemplateRequest): CreateSystemTemplateResponse {
        val op = SdkHttpOperation.build<CreateSystemTemplateRequest, CreateSystemTemplateResponse> {
            serializeWith = CreateSystemTemplateOperationSerializer()
            deserializeWith = CreateSystemTemplateOperationDeserializer()
            operationName = "CreateSystemTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deleteFlowTemplate(input: DeleteFlowTemplateRequest): DeleteFlowTemplateResponse {
        val op = SdkHttpOperation.build<DeleteFlowTemplateRequest, DeleteFlowTemplateResponse> {
            serializeWith = DeleteFlowTemplateOperationSerializer()
            deserializeWith = DeleteFlowTemplateOperationDeserializer()
            operationName = "DeleteFlowTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action. This action takes no request parameters.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse {
        val op = SdkHttpOperation.build<DeleteNamespaceRequest, DeleteNamespaceResponse> {
            serializeWith = DeleteNamespaceOperationSerializer()
            deserializeWith = DeleteNamespaceOperationDeserializer()
            operationName = "DeleteNamespace"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deleteSystemInstance(input: DeleteSystemInstanceRequest): DeleteSystemInstanceResponse {
        val op = SdkHttpOperation.build<DeleteSystemInstanceRequest, DeleteSystemInstanceResponse> {
            serializeWith = DeleteSystemInstanceOperationSerializer()
            deserializeWith = DeleteSystemInstanceOperationDeserializer()
            operationName = "DeleteSystemInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deleteSystemTemplate(input: DeleteSystemTemplateRequest): DeleteSystemTemplateResponse {
        val op = SdkHttpOperation.build<DeleteSystemTemplateRequest, DeleteSystemTemplateResponse> {
            serializeWith = DeleteSystemTemplateOperationSerializer()
            deserializeWith = DeleteSystemTemplateOperationDeserializer()
            operationName = "DeleteSystemTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deploySystemInstance(input: DeploySystemInstanceRequest): DeploySystemInstanceResponse {
        val op = SdkHttpOperation.build<DeploySystemInstanceRequest, DeploySystemInstanceResponse> {
            serializeWith = DeploySystemInstanceOperationSerializer()
            deserializeWith = DeploySystemInstanceOperationDeserializer()
            operationName = "DeploySystemInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deprecateFlowTemplate(input: DeprecateFlowTemplateRequest): DeprecateFlowTemplateResponse {
        val op = SdkHttpOperation.build<DeprecateFlowTemplateRequest, DeprecateFlowTemplateResponse> {
            serializeWith = DeprecateFlowTemplateOperationSerializer()
            deserializeWith = DeprecateFlowTemplateOperationDeserializer()
            operationName = "DeprecateFlowTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deprecates the specified system.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun deprecateSystemTemplate(input: DeprecateSystemTemplateRequest): DeprecateSystemTemplateResponse {
        val op = SdkHttpOperation.build<DeprecateSystemTemplateRequest, DeprecateSystemTemplateResponse> {
            serializeWith = DeprecateSystemTemplateOperationSerializer()
            deserializeWith = DeprecateSystemTemplateOperationDeserializer()
            operationName = "DeprecateSystemTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun describeNamespace(input: DescribeNamespaceRequest): DescribeNamespaceResponse {
        val op = SdkHttpOperation.build<DescribeNamespaceRequest, DescribeNamespaceResponse> {
            serializeWith = DescribeNamespaceOperationSerializer()
            deserializeWith = DescribeNamespaceOperationDeserializer()
            operationName = "DescribeNamespace"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun dissociateEntityFromThing(input: DissociateEntityFromThingRequest): DissociateEntityFromThingResponse {
        val op = SdkHttpOperation.build<DissociateEntityFromThingRequest, DissociateEntityFromThingResponse> {
            serializeWith = DissociateEntityFromThingOperationSerializer()
            deserializeWith = DissociateEntityFromThingOperationDeserializer()
            operationName = "DissociateEntityFromThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getEntities(input: GetEntitiesRequest): GetEntitiesResponse {
        val op = SdkHttpOperation.build<GetEntitiesRequest, GetEntitiesResponse> {
            serializeWith = GetEntitiesOperationSerializer()
            deserializeWith = GetEntitiesOperationDeserializer()
            operationName = "GetEntities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getFlowTemplate(input: GetFlowTemplateRequest): GetFlowTemplateResponse {
        val op = SdkHttpOperation.build<GetFlowTemplateRequest, GetFlowTemplateResponse> {
            serializeWith = GetFlowTemplateOperationSerializer()
            deserializeWith = GetFlowTemplateOperationDeserializer()
            operationName = "GetFlowTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getFlowTemplateRevisions(input: GetFlowTemplateRevisionsRequest): GetFlowTemplateRevisionsResponse {
        val op = SdkHttpOperation.build<GetFlowTemplateRevisionsRequest, GetFlowTemplateRevisionsResponse> {
            serializeWith = GetFlowTemplateRevisionsOperationSerializer()
            deserializeWith = GetFlowTemplateRevisionsOperationDeserializer()
            operationName = "GetFlowTemplateRevisions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of a namespace deletion task.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getNamespaceDeletionStatus(input: GetNamespaceDeletionStatusRequest): GetNamespaceDeletionStatusResponse {
        val op = SdkHttpOperation.build<GetNamespaceDeletionStatusRequest, GetNamespaceDeletionStatusResponse> {
            serializeWith = GetNamespaceDeletionStatusOperationSerializer()
            deserializeWith = GetNamespaceDeletionStatusOperationDeserializer()
            operationName = "GetNamespaceDeletionStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a system instance.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getSystemInstance(input: GetSystemInstanceRequest): GetSystemInstanceResponse {
        val op = SdkHttpOperation.build<GetSystemInstanceRequest, GetSystemInstanceResponse> {
            serializeWith = GetSystemInstanceOperationSerializer()
            deserializeWith = GetSystemInstanceOperationDeserializer()
            operationName = "GetSystemInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a system.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getSystemTemplate(input: GetSystemTemplateRequest): GetSystemTemplateResponse {
        val op = SdkHttpOperation.build<GetSystemTemplateRequest, GetSystemTemplateResponse> {
            serializeWith = GetSystemTemplateOperationSerializer()
            deserializeWith = GetSystemTemplateOperationDeserializer()
            operationName = "GetSystemTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getSystemTemplateRevisions(input: GetSystemTemplateRevisionsRequest): GetSystemTemplateRevisionsResponse {
        val op = SdkHttpOperation.build<GetSystemTemplateRevisionsRequest, GetSystemTemplateRevisionsResponse> {
            serializeWith = GetSystemTemplateRevisionsOperationSerializer()
            deserializeWith = GetSystemTemplateRevisionsOperationDeserializer()
            operationName = "GetSystemTemplateRevisions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified upload.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun getUploadStatus(input: GetUploadStatusRequest): GetUploadStatusResponse {
        val op = SdkHttpOperation.build<GetUploadStatusRequest, GetUploadStatusResponse> {
            serializeWith = GetUploadStatusOperationSerializer()
            deserializeWith = GetUploadStatusOperationDeserializer()
            operationName = "GetUploadStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun listFlowExecutionMessages(input: ListFlowExecutionMessagesRequest): ListFlowExecutionMessagesResponse {
        val op = SdkHttpOperation.build<ListFlowExecutionMessagesRequest, ListFlowExecutionMessagesResponse> {
            serializeWith = ListFlowExecutionMessagesOperationSerializer()
            deserializeWith = ListFlowExecutionMessagesOperationDeserializer()
            operationName = "ListFlowExecutionMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchEntities(input: SearchEntitiesRequest): SearchEntitiesResponse {
        val op = SdkHttpOperation.build<SearchEntitiesRequest, SearchEntitiesResponse> {
            serializeWith = SearchEntitiesOperationSerializer()
            deserializeWith = SearchEntitiesOperationDeserializer()
            operationName = "SearchEntities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchFlowExecutions(input: SearchFlowExecutionsRequest): SearchFlowExecutionsResponse {
        val op = SdkHttpOperation.build<SearchFlowExecutionsRequest, SearchFlowExecutionsResponse> {
            serializeWith = SearchFlowExecutionsOperationSerializer()
            deserializeWith = SearchFlowExecutionsOperationDeserializer()
            operationName = "SearchFlowExecutions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for summary information about workflows.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchFlowTemplates(input: SearchFlowTemplatesRequest): SearchFlowTemplatesResponse {
        val op = SdkHttpOperation.build<SearchFlowTemplatesRequest, SearchFlowTemplatesResponse> {
            serializeWith = SearchFlowTemplatesOperationSerializer()
            deserializeWith = SearchFlowTemplatesOperationDeserializer()
            operationName = "SearchFlowTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for system instances in the user's account.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchSystemInstances(input: SearchSystemInstancesRequest): SearchSystemInstancesResponse {
        val op = SdkHttpOperation.build<SearchSystemInstancesRequest, SearchSystemInstancesResponse> {
            serializeWith = SearchSystemInstancesOperationSerializer()
            deserializeWith = SearchSystemInstancesOperationDeserializer()
            operationName = "SearchSystemInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchSystemTemplates(input: SearchSystemTemplatesRequest): SearchSystemTemplatesResponse {
        val op = SdkHttpOperation.build<SearchSystemTemplatesRequest, SearchSystemTemplatesResponse> {
            serializeWith = SearchSystemTemplatesOperationSerializer()
            deserializeWith = SearchSystemTemplatesOperationDeserializer()
            operationName = "SearchSystemTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun searchThings(input: SearchThingsRequest): SearchThingsResponse {
        val op = SdkHttpOperation.build<SearchThingsRequest, SearchThingsResponse> {
            serializeWith = SearchThingsOperationSerializer()
            deserializeWith = SearchThingsOperationDeserializer()
            operationName = "SearchThings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a tag for the specified resource.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun undeploySystemInstance(input: UndeploySystemInstanceRequest): UndeploySystemInstanceResponse {
        val op = SdkHttpOperation.build<UndeploySystemInstanceRequest, UndeploySystemInstanceResponse> {
            serializeWith = UndeploySystemInstanceOperationSerializer()
            deserializeWith = UndeploySystemInstanceOperationDeserializer()
            operationName = "UndeploySystemInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from the specified resource.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun updateFlowTemplate(input: UpdateFlowTemplateRequest): UpdateFlowTemplateResponse {
        val op = SdkHttpOperation.build<UpdateFlowTemplateRequest, UpdateFlowTemplateResponse> {
            serializeWith = UpdateFlowTemplateOperationSerializer()
            deserializeWith = UpdateFlowTemplateOperationDeserializer()
            operationName = "UpdateFlowTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun updateSystemTemplate(input: UpdateSystemTemplateRequest): UpdateSystemTemplateResponse {
        val op = SdkHttpOperation.build<UpdateSystemTemplateRequest, UpdateSystemTemplateResponse> {
            serializeWith = UpdateSystemTemplateOperationSerializer()
            deserializeWith = UpdateSystemTemplateOperationDeserializer()
            operationName = "UpdateSystemTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    @Deprecated("since: 2022-08-30")
    override suspend fun uploadEntityDefinitions(input: UploadEntityDefinitionsRequest): UploadEntityDefinitionsResponse {
        val op = SdkHttpOperation.build<UploadEntityDefinitionsRequest, UploadEntityDefinitionsResponse> {
            serializeWith = UploadEntityDefinitionsOperationSerializer()
            deserializeWith = UploadEntityDefinitionsOperationDeserializer()
            operationName = "UploadEntityDefinitions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(HttpOperationContext.AttemptTimeout, config.attemptTimeout)
        ctx.putIfAbsentNotNull(HttpOperationContext.CallTimeout, config.callTimeout)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotthingsgraph")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
