// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.CapabilitySyncStatus
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateGatewayCapabilityConfigurationOperationDeserializer: HttpDeserialize<UpdateGatewayCapabilityConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateGatewayCapabilityConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwUpdateGatewayCapabilityConfigurationError(context, response)
        }
        val builder = UpdateGatewayCapabilityConfigurationResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateGatewayCapabilityConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateGatewayCapabilityConfigurationOperationBody(builder: UpdateGatewayCapabilityConfigurationResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPABILITYNAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilityNamespace"))
    val CAPABILITYSYNCSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilitySyncStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITYNAMESPACE_DESCRIPTOR)
        field(CAPABILITYSYNCSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITYNAMESPACE_DESCRIPTOR.index -> builder.capabilityNamespace = deserializeString()
                CAPABILITYSYNCSTATUS_DESCRIPTOR.index -> builder.capabilitySyncStatus = deserializeString().let { CapabilitySyncStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateGatewayCapabilityConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer()
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
