// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.services.iotsitewise.model.UpdateAccessPolicyRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAccessPolicyOperationSerializer: HttpSerialize<UpdateAccessPolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAccessPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "access-policies",
                "${input.accessPolicyId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAccessPolicyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAccessPolicyOperationBody(context: ExecutionContext, input: UpdateAccessPolicyRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSPOLICYIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyIdentity"))
    val ACCESSPOLICYPERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyPermission"))
    val ACCESSPOLICYRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyResource"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOLICYIDENTITY_DESCRIPTOR)
        field(ACCESSPOLICYPERMISSION_DESCRIPTOR)
        field(ACCESSPOLICYRESOURCE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessPolicyIdentity?.let { field(ACCESSPOLICYIDENTITY_DESCRIPTOR, it, ::serializeIdentityDocument) }
        input.accessPolicyPermission?.let { field(ACCESSPOLICYPERMISSION_DESCRIPTOR, it.value) }
        input.accessPolicyResource?.let { field(ACCESSPOLICYRESOURCE_DESCRIPTOR, it, ::serializeResourceDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
    }
    return serializer.toByteArray()
}
