// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DescribeProjectResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeProjectOperationDeserializer: HttpDeserialize<DescribeProjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProjectResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProjectError(context, response)
        }
        val builder = DescribeProjectResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProjectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeProjectOperationBody(builder: DescribeProjectResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PROJECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectArn"))
    val PROJECTCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("projectCreationDate"))
    val PROJECTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectDescription"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val PROJECTLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("projectLastUpdateDate"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PORTALID_DESCRIPTOR)
        field(PROJECTARN_DESCRIPTOR)
        field(PROJECTCREATIONDATE_DESCRIPTOR)
        field(PROJECTDESCRIPTION_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(PROJECTLASTUPDATEDATE_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PROJECTARN_DESCRIPTOR.index -> builder.projectArn = deserializeString()
                PROJECTCREATIONDATE_DESCRIPTOR.index -> builder.projectCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                PROJECTDESCRIPTION_DESCRIPTOR.index -> builder.projectDescription = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                PROJECTLASTUPDATEDATE_DESCRIPTOR.index -> builder.projectLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeProjectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
