// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.AuthMode
import aws.sdk.kotlin.services.iotsitewise.model.DescribePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribePortalOperationDeserializer: HttpDeserialize<DescribePortalResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePortalResponse {
        if (!response.status.isSuccess()) {
            throwDescribePortalError(context, response)
        }
        val builder = DescribePortalResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePortalOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribePortalOperationBody(builder: DescribePortalResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarms"))
    val NOTIFICATIONSENDEREMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notificationSenderEmail"))
    val PORTALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalArn"))
    val PORTALAUTHMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalAuthMode"))
    val PORTALCLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalClientId"))
    val PORTALCONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalContactEmail"))
    val PORTALCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("portalCreationDate"))
    val PORTALDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalDescription"))
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PORTALLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("portalLastUpdateDate"))
    val PORTALLOGOIMAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalLogoImageLocation"))
    val PORTALNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalName"))
    val PORTALSTARTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalStartUrl"))
    val PORTALSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalStatus"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMS_DESCRIPTOR)
        field(NOTIFICATIONSENDEREMAIL_DESCRIPTOR)
        field(PORTALARN_DESCRIPTOR)
        field(PORTALAUTHMODE_DESCRIPTOR)
        field(PORTALCLIENTID_DESCRIPTOR)
        field(PORTALCONTACTEMAIL_DESCRIPTOR)
        field(PORTALCREATIONDATE_DESCRIPTOR)
        field(PORTALDESCRIPTION_DESCRIPTOR)
        field(PORTALID_DESCRIPTOR)
        field(PORTALLASTUPDATEDATE_DESCRIPTOR)
        field(PORTALLOGOIMAGELOCATION_DESCRIPTOR)
        field(PORTALNAME_DESCRIPTOR)
        field(PORTALSTARTURL_DESCRIPTOR)
        field(PORTALSTATUS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMS_DESCRIPTOR.index -> builder.alarms = deserializeAlarmsDocument(deserializer)
                NOTIFICATIONSENDEREMAIL_DESCRIPTOR.index -> builder.notificationSenderEmail = deserializeString()
                PORTALARN_DESCRIPTOR.index -> builder.portalArn = deserializeString()
                PORTALAUTHMODE_DESCRIPTOR.index -> builder.portalAuthMode = deserializeString().let { AuthMode.fromValue(it) }
                PORTALCLIENTID_DESCRIPTOR.index -> builder.portalClientId = deserializeString()
                PORTALCONTACTEMAIL_DESCRIPTOR.index -> builder.portalContactEmail = deserializeString()
                PORTALCREATIONDATE_DESCRIPTOR.index -> builder.portalCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                PORTALDESCRIPTION_DESCRIPTOR.index -> builder.portalDescription = deserializeString()
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PORTALLASTUPDATEDATE_DESCRIPTOR.index -> builder.portalLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                PORTALLOGOIMAGELOCATION_DESCRIPTOR.index -> builder.portalLogoImageLocation = deserializeImageLocationDocument(deserializer)
                PORTALNAME_DESCRIPTOR.index -> builder.portalName = deserializeString()
                PORTALSTARTURL_DESCRIPTOR.index -> builder.portalStartUrl = deserializeString()
                PORTALSTATUS_DESCRIPTOR.index -> builder.portalStatus = deserializePortalStatusDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribePortalError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
