// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayResponse
import aws.sdk.kotlin.services.iotsitewise.model.GatewayCapabilitySummary
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeGatewayOperationDeserializer: HttpDeserialize<DescribeGatewayResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeGatewayResponse {
        if (!response.status.isSuccess()) {
            throwDescribeGatewayError(context, response)
        }
        val builder = DescribeGatewayResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeGatewayOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeGatewayOperationBody(builder: DescribeGatewayResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayArn"))
    val GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("gatewayCapabilitySummaries"))
    val GATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayId"))
    val GATEWAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayName"))
    val GATEWAYPLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("gatewayPlatform"))
    val LASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR)
        field(GATEWAYID_DESCRIPTOR)
        field(GATEWAYNAME_DESCRIPTOR)
        field(GATEWAYPLATFORM_DESCRIPTOR)
        field(LASTUPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR.index -> builder.gatewayCapabilitySummaries =
                    deserializer.deserializeList(GATEWAYCAPABILITYSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<GatewayCapabilitySummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGatewayCapabilitySummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYID_DESCRIPTOR.index -> builder.gatewayId = deserializeString()
                GATEWAYNAME_DESCRIPTOR.index -> builder.gatewayName = deserializeString()
                GATEWAYPLATFORM_DESCRIPTOR.index -> builder.gatewayPlatform = deserializeGatewayPlatformDocument(deserializer)
                LASTUPDATEDATE_DESCRIPTOR.index -> builder.lastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeGatewayError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
