// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.CapabilitySyncStatus
import aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeGatewayCapabilityConfigurationOperationDeserializer: HttpDeserialize<DescribeGatewayCapabilityConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeGatewayCapabilityConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeGatewayCapabilityConfigurationError(context, response)
        }
        val builder = DescribeGatewayCapabilityConfigurationResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeGatewayCapabilityConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeGatewayCapabilityConfigurationOperationBody(builder: DescribeGatewayCapabilityConfigurationResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPABILITYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilityConfiguration"))
    val CAPABILITYNAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilityNamespace"))
    val CAPABILITYSYNCSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilitySyncStatus"))
    val GATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("gatewayId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITYCONFIGURATION_DESCRIPTOR)
        field(CAPABILITYNAMESPACE_DESCRIPTOR)
        field(CAPABILITYSYNCSTATUS_DESCRIPTOR)
        field(GATEWAYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITYCONFIGURATION_DESCRIPTOR.index -> builder.capabilityConfiguration = deserializeString()
                CAPABILITYNAMESPACE_DESCRIPTOR.index -> builder.capabilityNamespace = deserializeString()
                CAPABILITYSYNCSTATUS_DESCRIPTOR.index -> builder.capabilitySyncStatus = deserializeString().let { CapabilitySyncStatus.fromValue(it) }
                GATEWAYID_DESCRIPTOR.index -> builder.gatewayId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeGatewayCapabilityConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
