// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DescribeDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDashboardOperationDeserializer: HttpDeserialize<DescribeDashboardResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDashboardResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDashboardError(context, response)
        }
        val builder = DescribeDashboardResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDashboardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeDashboardOperationBody(builder: DescribeDashboardResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardArn"))
    val DASHBOARDCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("dashboardCreationDate"))
    val DASHBOARDDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardDefinition"))
    val DASHBOARDDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardDescription"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardId"))
    val DASHBOARDLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("dashboardLastUpdateDate"))
    val DASHBOARDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardName"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDARN_DESCRIPTOR)
        field(DASHBOARDCREATIONDATE_DESCRIPTOR)
        field(DASHBOARDDEFINITION_DESCRIPTOR)
        field(DASHBOARDDESCRIPTION_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
        field(DASHBOARDLASTUPDATEDATE_DESCRIPTOR)
        field(DASHBOARDNAME_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                DASHBOARDCREATIONDATE_DESCRIPTOR.index -> builder.dashboardCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DASHBOARDDEFINITION_DESCRIPTOR.index -> builder.dashboardDefinition = deserializeString()
                DASHBOARDDESCRIPTION_DESCRIPTOR.index -> builder.dashboardDescription = deserializeString()
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                DASHBOARDLASTUPDATEDATE_DESCRIPTOR.index -> builder.dashboardLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DASHBOARDNAME_DESCRIPTOR.index -> builder.dashboardName = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeDashboardError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
