// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetPropertyResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAssetPropertyOperationDeserializer: HttpDeserialize<DescribeAssetPropertyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAssetPropertyResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAssetPropertyError(context, response)
        }
        val builder = DescribeAssetPropertyResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAssetPropertyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAssetPropertyOperationBody(builder: DescribeAssetPropertyResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetName"))
    val ASSETPROPERTY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetProperty"))
    val COMPOSITEMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compositeModel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETID_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETNAME_DESCRIPTOR)
        field(ASSETPROPERTY_DESCRIPTOR)
        field(COMPOSITEMODEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETNAME_DESCRIPTOR.index -> builder.assetName = deserializeString()
                ASSETPROPERTY_DESCRIPTOR.index -> builder.assetProperty = deserializePropertyDocument(deserializer)
                COMPOSITEMODEL_DESCRIPTOR.index -> builder.compositeModel = deserializeCompositeModelPropertyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAssetPropertyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
