// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel
import aws.sdk.kotlin.services.iotsitewise.model.AssetHierarchy
import aws.sdk.kotlin.services.iotsitewise.model.AssetProperty
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAssetOperationDeserializer: HttpDeserialize<DescribeAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAssetResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAssetError(context, response)
        }
        val builder = DescribeAssetResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAssetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAssetOperationBody(builder: DescribeAssetResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetArn"))
    val ASSETCOMPOSITEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetCompositeModels"))
    val ASSETCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetCreationDate"))
    val ASSETHIERARCHIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetHierarchies"))
    val ASSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetId"))
    val ASSETLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetLastUpdateDate"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetName"))
    val ASSETPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetProperties"))
    val ASSETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETARN_DESCRIPTOR)
        field(ASSETCOMPOSITEMODELS_DESCRIPTOR)
        field(ASSETCREATIONDATE_DESCRIPTOR)
        field(ASSETHIERARCHIES_DESCRIPTOR)
        field(ASSETID_DESCRIPTOR)
        field(ASSETLASTUPDATEDATE_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETNAME_DESCRIPTOR)
        field(ASSETPROPERTIES_DESCRIPTOR)
        field(ASSETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETARN_DESCRIPTOR.index -> builder.assetArn = deserializeString()
                ASSETCOMPOSITEMODELS_DESCRIPTOR.index -> builder.assetCompositeModels =
                    deserializer.deserializeList(ASSETCOMPOSITEMODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetCompositeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetCompositeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETCREATIONDATE_DESCRIPTOR.index -> builder.assetCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ASSETHIERARCHIES_DESCRIPTOR.index -> builder.assetHierarchies =
                    deserializer.deserializeList(ASSETHIERARCHIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetHierarchy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetHierarchyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETID_DESCRIPTOR.index -> builder.assetId = deserializeString()
                ASSETLASTUPDATEDATE_DESCRIPTOR.index -> builder.assetLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETNAME_DESCRIPTOR.index -> builder.assetName = deserializeString()
                ASSETPROPERTIES_DESCRIPTOR.index -> builder.assetProperties =
                    deserializer.deserializeList(ASSETPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETSTATUS_DESCRIPTOR.index -> builder.assetStatus = deserializeAssetStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAssetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
