// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelCompositeModel
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelHierarchy
import aws.sdk.kotlin.services.iotsitewise.model.AssetModelProperty
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAssetModelResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAssetModelOperationDeserializer: HttpDeserialize<DescribeAssetModelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAssetModelResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAssetModelError(context, response)
        }
        val builder = DescribeAssetModelResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAssetModelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAssetModelOperationBody(builder: DescribeAssetModelResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelArn"))
    val ASSETMODELCOMPOSITEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelCompositeModels"))
    val ASSETMODELCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetModelCreationDate"))
    val ASSETMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelDescription"))
    val ASSETMODELHIERARCHIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelHierarchies"))
    val ASSETMODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelId"))
    val ASSETMODELLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("assetModelLastUpdateDate"))
    val ASSETMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assetModelName"))
    val ASSETMODELPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetModelProperties"))
    val ASSETMODELSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetModelStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETMODELARN_DESCRIPTOR)
        field(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR)
        field(ASSETMODELCREATIONDATE_DESCRIPTOR)
        field(ASSETMODELDESCRIPTION_DESCRIPTOR)
        field(ASSETMODELHIERARCHIES_DESCRIPTOR)
        field(ASSETMODELID_DESCRIPTOR)
        field(ASSETMODELLASTUPDATEDATE_DESCRIPTOR)
        field(ASSETMODELNAME_DESCRIPTOR)
        field(ASSETMODELPROPERTIES_DESCRIPTOR)
        field(ASSETMODELSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETMODELARN_DESCRIPTOR.index -> builder.assetModelArn = deserializeString()
                ASSETMODELCOMPOSITEMODELS_DESCRIPTOR.index -> builder.assetModelCompositeModels =
                    deserializer.deserializeList(ASSETMODELCOMPOSITEMODELS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelCompositeModel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelCompositeModelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELCREATIONDATE_DESCRIPTOR.index -> builder.assetModelCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ASSETMODELDESCRIPTION_DESCRIPTOR.index -> builder.assetModelDescription = deserializeString()
                ASSETMODELHIERARCHIES_DESCRIPTOR.index -> builder.assetModelHierarchies =
                    deserializer.deserializeList(ASSETMODELHIERARCHIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelHierarchy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelHierarchyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELID_DESCRIPTOR.index -> builder.assetModelId = deserializeString()
                ASSETMODELLASTUPDATEDATE_DESCRIPTOR.index -> builder.assetModelLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ASSETMODELNAME_DESCRIPTOR.index -> builder.assetModelName = deserializeString()
                ASSETMODELPROPERTIES_DESCRIPTOR.index -> builder.assetModelProperties =
                    deserializer.deserializeList(ASSETMODELPROPERTIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetModelProperty>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetModelPropertyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSETMODELSTATUS_DESCRIPTOR.index -> builder.assetModelStatus = deserializeAssetModelStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAssetModelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
