// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DescribeAccessPolicyResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.sdk.kotlin.services.iotsitewise.model.Permission
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAccessPolicyOperationDeserializer: HttpDeserialize<DescribeAccessPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccessPolicyResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccessPolicyError(context, response)
        }
        val builder = DescribeAccessPolicyResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccessPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeAccessPolicyOperationBody(builder: DescribeAccessPolicyResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSPOLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyArn"))
    val ACCESSPOLICYCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("accessPolicyCreationDate"))
    val ACCESSPOLICYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyId"))
    val ACCESSPOLICYIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyIdentity"))
    val ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("accessPolicyLastUpdateDate"))
    val ACCESSPOLICYPERMISSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessPolicyPermission"))
    val ACCESSPOLICYRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessPolicyResource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSPOLICYARN_DESCRIPTOR)
        field(ACCESSPOLICYCREATIONDATE_DESCRIPTOR)
        field(ACCESSPOLICYID_DESCRIPTOR)
        field(ACCESSPOLICYIDENTITY_DESCRIPTOR)
        field(ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR)
        field(ACCESSPOLICYPERMISSION_DESCRIPTOR)
        field(ACCESSPOLICYRESOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOLICYARN_DESCRIPTOR.index -> builder.accessPolicyArn = deserializeString()
                ACCESSPOLICYCREATIONDATE_DESCRIPTOR.index -> builder.accessPolicyCreationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ACCESSPOLICYID_DESCRIPTOR.index -> builder.accessPolicyId = deserializeString()
                ACCESSPOLICYIDENTITY_DESCRIPTOR.index -> builder.accessPolicyIdentity = deserializeIdentityDocument(deserializer)
                ACCESSPOLICYLASTUPDATEDATE_DESCRIPTOR.index -> builder.accessPolicyLastUpdateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ACCESSPOLICYPERMISSION_DESCRIPTOR.index -> builder.accessPolicyPermission = deserializeString().let { Permission.fromValue(it) }
                ACCESSPOLICYRESOURCE_DESCRIPTOR.index -> builder.accessPolicyResource = deserializeResourceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeAccessPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
