// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.DeleteAssetResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteAssetOperationDeserializer: HttpDeserialize<DeleteAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteAssetResponse {
        if (!response.status.isSuccess()) {
            throwDeleteAssetError(context, response)
        }
        val builder = DeleteAssetResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteAssetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDeleteAssetOperationBody(builder: DeleteAssetResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETSTATUS_DESCRIPTOR.index -> builder.assetStatus = deserializeAssetStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDeleteAssetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConflictingOperationException" -> ConflictingOperationExceptionDeserializer()
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
