// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePortalOperationDeserializer: HttpDeserialize<CreatePortalResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePortalResponse {
        if (!response.status.isSuccess()) {
            throwCreatePortalError(context, response)
        }
        val builder = CreatePortalResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePortalOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreatePortalOperationBody(builder: CreatePortalResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PORTALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalArn"))
    val PORTALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalId"))
    val PORTALSTARTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalStartUrl"))
    val PORTALSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("portalStatus"))
    val SSOAPPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ssoApplicationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PORTALARN_DESCRIPTOR)
        field(PORTALID_DESCRIPTOR)
        field(PORTALSTARTURL_DESCRIPTOR)
        field(PORTALSTATUS_DESCRIPTOR)
        field(SSOAPPLICATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PORTALARN_DESCRIPTOR.index -> builder.portalArn = deserializeString()
                PORTALID_DESCRIPTOR.index -> builder.portalId = deserializeString()
                PORTALSTARTURL_DESCRIPTOR.index -> builder.portalStartUrl = deserializeString()
                PORTALSTATUS_DESCRIPTOR.index -> builder.portalStatus = deserializePortalStatusDocument(deserializer)
                SSOAPPLICATIONID_DESCRIPTOR.index -> builder.ssoApplicationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreatePortalError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
