// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsitewise.model.CreateDashboardResponse
import aws.sdk.kotlin.services.iotsitewise.model.IoTSiteWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDashboardOperationDeserializer: HttpDeserialize<CreateDashboardResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDashboardResponse {
        if (!response.status.isSuccess()) {
            throwCreateDashboardError(context, response)
        }
        val builder = CreateDashboardResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDashboardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateDashboardOperationBody(builder: CreateDashboardResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DASHBOARDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardArn"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dashboardId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDARN_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDARN_DESCRIPTOR.index -> builder.dashboardArn = deserializeString()
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateDashboardError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTSiteWiseException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
