// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class UpdatePortalRequest private constructor(builder: BuilderImpl) {
    /**
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
     * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
     */
    val alarms: Alarms? = builder.alarms
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The email address that sends alarm notifications.
     */
    val notificationSenderEmail: String? = builder.notificationSenderEmail
    /**
     * The Amazon Web Services administrator's contact email address.
     */
    val portalContactEmail: String? = builder.portalContactEmail
    /**
     * A new description for the portal.
     */
    val portalDescription: String? = builder.portalDescription
    /**
     * The ID of the portal to update.
     */
    val portalId: String? = builder.portalId
    /**
     * Contains an image that is one of the following:
     * An image file. Choose this option to upload a new image.
     * The ID of an existing image. Choose this option to keep an existing image.
     */
    val portalLogoImage: Image? = builder.portalLogoImage
    /**
     * A new friendly name for the portal.
     */
    val portalName: String? = builder.portalName
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
     * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
     * IoT SiteWise User Guide.
     */
    val roleArn: String? = builder.roleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdatePortalRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePortalRequest(")
        append("alarms=$alarms,")
        append("clientToken=$clientToken,")
        append("notificationSenderEmail=$notificationSenderEmail,")
        append("portalContactEmail=$portalContactEmail,")
        append("portalDescription=$portalDescription,")
        append("portalId=$portalId,")
        append("portalLogoImage=$portalLogoImage,")
        append("portalName=$portalName,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (notificationSenderEmail?.hashCode() ?: 0)
        result = 31 * result + (portalContactEmail?.hashCode() ?: 0)
        result = 31 * result + (portalDescription?.hashCode() ?: 0)
        result = 31 * result + (portalId?.hashCode() ?: 0)
        result = 31 * result + (portalLogoImage?.hashCode() ?: 0)
        result = 31 * result + (portalName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdatePortalRequest

        if (alarms != other.alarms) return false
        if (clientToken != other.clientToken) return false
        if (notificationSenderEmail != other.notificationSenderEmail) return false
        if (portalContactEmail != other.portalContactEmail) return false
        if (portalDescription != other.portalDescription) return false
        if (portalId != other.portalId) return false
        if (portalLogoImage != other.portalLogoImage) return false
        if (portalName != other.portalName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdatePortalRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdatePortalRequest
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
         */
        fun alarms(alarms: Alarms): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The email address that sends alarm notifications.
         */
        fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        fun portalContactEmail(portalContactEmail: String): FluentBuilder
        /**
         * A new description for the portal.
         */
        fun portalDescription(portalDescription: String): FluentBuilder
        /**
         * The ID of the portal to update.
         */
        fun portalId(portalId: String): FluentBuilder
        /**
         * Contains an image that is one of the following:
         * An image file. Choose this option to upload a new image.
         * The ID of an existing image. Choose this option to keep an existing image.
         */
        fun portalLogoImage(portalLogoImage: Image): FluentBuilder
        /**
         * A new friendly name for the portal.
         */
        fun portalName(portalName: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        fun roleArn(roleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms in the IoT SiteWise Application Guide.
         */
        var alarms: Alarms?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * The email address that sends alarm notifications.
         */
        var notificationSenderEmail: String?
        /**
         * The Amazon Web Services administrator's contact email address.
         */
        var portalContactEmail: String?
        /**
         * A new description for the portal.
         */
        var portalDescription: String?
        /**
         * The ID of the portal to update.
         */
        var portalId: String?
        /**
         * Contains an image that is one of the following:
         * An image file. Choose this option to upload a new image.
         * The ID of an existing image. Choose this option to keep an existing image.
         */
        var portalLogoImage: Image?
        /**
         * A new friendly name for the portal.
         */
        var portalName: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of a service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        var roleArn: String?

        fun build(): UpdatePortalRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Alarms] inside the given [block]
         */
        fun alarms(block: Alarms.DslBuilder.() -> kotlin.Unit) {
            this.alarms = Alarms.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Image] inside the given [block]
         */
        fun portalLogoImage(block: Image.DslBuilder.() -> kotlin.Unit) {
            this.portalLogoImage = Image.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alarms: Alarms? = null
        override var clientToken: String? = null
        override var notificationSenderEmail: String? = null
        override var portalContactEmail: String? = null
        override var portalDescription: String? = null
        override var portalId: String? = null
        override var portalLogoImage: Image? = null
        override var portalName: String? = null
        override var roleArn: String? = null

        constructor(x: UpdatePortalRequest) : this() {
            this.alarms = x.alarms
            this.clientToken = x.clientToken
            this.notificationSenderEmail = x.notificationSenderEmail
            this.portalContactEmail = x.portalContactEmail
            this.portalDescription = x.portalDescription
            this.portalId = x.portalId
            this.portalLogoImage = x.portalLogoImage
            this.portalName = x.portalName
            this.roleArn = x.roleArn
        }

        override fun build(): UpdatePortalRequest = UpdatePortalRequest(this)
        override fun alarms(alarms: Alarms): FluentBuilder = apply { this.alarms = alarms }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun notificationSenderEmail(notificationSenderEmail: String): FluentBuilder = apply { this.notificationSenderEmail = notificationSenderEmail }
        override fun portalContactEmail(portalContactEmail: String): FluentBuilder = apply { this.portalContactEmail = portalContactEmail }
        override fun portalDescription(portalDescription: String): FluentBuilder = apply { this.portalDescription = portalDescription }
        override fun portalId(portalId: String): FluentBuilder = apply { this.portalId = portalId }
        override fun portalLogoImage(portalLogoImage: Image): FluentBuilder = apply { this.portalLogoImage = portalLogoImage }
        override fun portalName(portalName: String): FluentBuilder = apply { this.portalName = portalName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
    }
}
