// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class UpdateGatewayCapabilityConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The JSON document that defines the configuration for the gateway capability. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
     */
    val capabilityConfiguration: String? = builder.capabilityConfiguration
    /**
     * The namespace of the gateway capability configuration to be updated.
     * For example, if you configure OPC-UA
     * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
     * iotsitewise:opcuacollector:version, where version is a number such as
     * 1.
     */
    val capabilityNamespace: String? = builder.capabilityNamespace
    /**
     * The ID of the gateway to be updated.
     */
    val gatewayId: String? = builder.gatewayId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateGatewayCapabilityConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGatewayCapabilityConfigurationRequest(")
        append("capabilityConfiguration=$capabilityConfiguration,")
        append("capabilityNamespace=$capabilityNamespace,")
        append("gatewayId=$gatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityConfiguration?.hashCode() ?: 0
        result = 31 * result + (capabilityNamespace?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateGatewayCapabilityConfigurationRequest

        if (capabilityConfiguration != other.capabilityConfiguration) return false
        if (capabilityNamespace != other.capabilityNamespace) return false
        if (gatewayId != other.gatewayId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateGatewayCapabilityConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateGatewayCapabilityConfigurationRequest
        /**
         * The JSON document that defines the configuration for the gateway capability. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
         */
        fun capabilityConfiguration(capabilityConfiguration: String): FluentBuilder
        /**
         * The namespace of the gateway capability configuration to be updated.
         * For example, if you configure OPC-UA
         * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         * iotsitewise:opcuacollector:version, where version is a number such as
         * 1.
         */
        fun capabilityNamespace(capabilityNamespace: String): FluentBuilder
        /**
         * The ID of the gateway to be updated.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The JSON document that defines the configuration for the gateway capability. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI) in the IoT SiteWise User Guide.
         */
        var capabilityConfiguration: String?
        /**
         * The namespace of the gateway capability configuration to be updated.
         * For example, if you configure OPC-UA
         * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         * iotsitewise:opcuacollector:version, where version is a number such as
         * 1.
         */
        var capabilityNamespace: String?
        /**
         * The ID of the gateway to be updated.
         */
        var gatewayId: String?

        fun build(): UpdateGatewayCapabilityConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capabilityConfiguration: String? = null
        override var capabilityNamespace: String? = null
        override var gatewayId: String? = null

        constructor(x: UpdateGatewayCapabilityConfigurationRequest) : this() {
            this.capabilityConfiguration = x.capabilityConfiguration
            this.capabilityNamespace = x.capabilityNamespace
            this.gatewayId = x.gatewayId
        }

        override fun build(): UpdateGatewayCapabilityConfigurationRequest = UpdateGatewayCapabilityConfigurationRequest(this)
        override fun capabilityConfiguration(capabilityConfiguration: String): FluentBuilder = apply { this.capabilityConfiguration = capabilityConfiguration }
        override fun capabilityNamespace(capabilityNamespace: String): FluentBuilder = apply { this.capabilityNamespace = capabilityNamespace }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
    }
}
