// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class UpdateAssetPropertyRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset to be updated.
     */
    val assetId: String? = builder.assetId
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     * If you omit this parameter, the alias is removed from the property.
     */
    val propertyAlias: String? = builder.propertyAlias
    /**
     * The ID of the asset property to be updated.
     */
    val propertyId: String? = builder.propertyId
    /**
     * The MQTT notification state (enabled or disabled) for this asset property.
     * When the notification state is enabled, IoT SiteWise publishes property value
     * updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services in the IoT SiteWise User Guide.
     * If you omit this parameter, the notification state is set to DISABLED.
     */
    val propertyNotificationState: PropertyNotificationState? = builder.propertyNotificationState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateAssetPropertyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAssetPropertyRequest(")
        append("assetId=$assetId,")
        append("clientToken=$clientToken,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("propertyNotificationState=$propertyNotificationState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (propertyNotificationState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateAssetPropertyRequest

        if (assetId != other.assetId) return false
        if (clientToken != other.clientToken) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (propertyNotificationState != other.propertyNotificationState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateAssetPropertyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateAssetPropertyRequest
        /**
         * The ID of the asset to be updated.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         * If you omit this parameter, the alias is removed from the property.
         */
        fun propertyAlias(propertyAlias: String): FluentBuilder
        /**
         * The ID of the asset property to be updated.
         */
        fun propertyId(propertyId: String): FluentBuilder
        /**
         * The MQTT notification state (enabled or disabled) for this asset property.
         * When the notification state is enabled, IoT SiteWise publishes property value
         * updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services in the IoT SiteWise User Guide.
         * If you omit this parameter, the notification state is set to DISABLED.
         */
        fun propertyNotificationState(propertyNotificationState: PropertyNotificationState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset to be updated.
         */
        var assetId: String?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         * If you omit this parameter, the alias is removed from the property.
         */
        var propertyAlias: String?
        /**
         * The ID of the asset property to be updated.
         */
        var propertyId: String?
        /**
         * The MQTT notification state (enabled or disabled) for this asset property.
         * When the notification state is enabled, IoT SiteWise publishes property value
         * updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services in the IoT SiteWise User Guide.
         * If you omit this parameter, the notification state is set to DISABLED.
         */
        var propertyNotificationState: PropertyNotificationState?

        fun build(): UpdateAssetPropertyRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var clientToken: String? = null
        override var propertyAlias: String? = null
        override var propertyId: String? = null
        override var propertyNotificationState: PropertyNotificationState? = null

        constructor(x: UpdateAssetPropertyRequest) : this() {
            this.assetId = x.assetId
            this.clientToken = x.clientToken
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.propertyNotificationState = x.propertyNotificationState
        }

        override fun build(): UpdateAssetPropertyRequest = UpdateAssetPropertyRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun propertyAlias(propertyAlias: String): FluentBuilder = apply { this.propertyAlias = propertyAlias }
        override fun propertyId(propertyId: String): FluentBuilder = apply { this.propertyId = propertyId }
        override fun propertyNotificationState(propertyNotificationState: PropertyNotificationState): FluentBuilder = apply { this.propertyNotificationState = propertyNotificationState }
    }
}
