// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class UpdateAssetModelRequest private constructor(builder: BuilderImpl) {
    /**
     * The composite asset models that are part of this asset model.
     * Composite asset models are asset models that contain specific properties. Each composite model
     * has a type that defines the properties that the composite model supports. Use composite asset
     * models to define alarms on this asset model.
     */
    val assetModelCompositeModels: List<AssetModelCompositeModel>? = builder.assetModelCompositeModels
    /**
     * A description for the asset model.
     */
    val assetModelDescription: String? = builder.assetModelDescription
    /**
     * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
     * model whose assets can be children of any other assets created from this asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
     * You can specify up to 10 hierarchies per asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val assetModelHierarchies: List<AssetModelHierarchy>? = builder.assetModelHierarchies
    /**
     * The ID of the asset model to update.
     */
    val assetModelId: String? = builder.assetModelId
    /**
     * A unique, friendly name for the asset model.
     */
    val assetModelName: String? = builder.assetModelName
    /**
     * The updated property definitions of the asset model. For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
     * You can specify up to 200 properties per asset model. For more
     * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val assetModelProperties: List<AssetModelProperty>? = builder.assetModelProperties
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateAssetModelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAssetModelRequest(")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelId=$assetModelId,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("clientToken=$clientToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelCompositeModels?.hashCode() ?: 0
        result = 31 * result + (assetModelDescription?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (assetModelName?.hashCode() ?: 0)
        result = 31 * result + (assetModelProperties?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateAssetModelRequest

        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (clientToken != other.clientToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateAssetModelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateAssetModelRequest
        /**
         * The composite asset models that are part of this asset model.
         * Composite asset models are asset models that contain specific properties. Each composite model
         * has a type that defines the properties that the composite model supports. Use composite asset
         * models to define alarms on this asset model.
         */
        fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModel>): FluentBuilder
        /**
         * A description for the asset model.
         */
        fun assetModelDescription(assetModelDescription: String): FluentBuilder
        /**
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
         * model whose assets can be children of any other assets created from this asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         * You can specify up to 10 hierarchies per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchy>): FluentBuilder
        /**
         * The ID of the asset model to update.
         */
        fun assetModelId(assetModelId: String): FluentBuilder
        /**
         * A unique, friendly name for the asset model.
         */
        fun assetModelName(assetModelName: String): FluentBuilder
        /**
         * The updated property definitions of the asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
         * You can specify up to 200 properties per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun assetModelProperties(assetModelProperties: List<AssetModelProperty>): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The composite asset models that are part of this asset model.
         * Composite asset models are asset models that contain specific properties. Each composite model
         * has a type that defines the properties that the composite model supports. Use composite asset
         * models to define alarms on this asset model.
         */
        var assetModelCompositeModels: List<AssetModelCompositeModel>?
        /**
         * A description for the asset model.
         */
        var assetModelDescription: String?
        /**
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset
         * model whose assets can be children of any other assets created from this asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         * You can specify up to 10 hierarchies per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var assetModelHierarchies: List<AssetModelHierarchy>?
        /**
         * The ID of the asset model to update.
         */
        var assetModelId: String?
        /**
         * A unique, friendly name for the asset model.
         */
        var assetModelName: String?
        /**
         * The updated property definitions of the asset model. For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties in the IoT SiteWise User Guide.
         * You can specify up to 200 properties per asset model. For more
         * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var assetModelProperties: List<AssetModelProperty>?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?

        fun build(): UpdateAssetModelRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetModelCompositeModels: List<AssetModelCompositeModel>? = null
        override var assetModelDescription: String? = null
        override var assetModelHierarchies: List<AssetModelHierarchy>? = null
        override var assetModelId: String? = null
        override var assetModelName: String? = null
        override var assetModelProperties: List<AssetModelProperty>? = null
        override var clientToken: String? = null

        constructor(x: UpdateAssetModelRequest) : this() {
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelDescription = x.assetModelDescription
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelId = x.assetModelId
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.clientToken = x.clientToken
        }

        override fun build(): UpdateAssetModelRequest = UpdateAssetModelRequest(this)
        override fun assetModelCompositeModels(assetModelCompositeModels: List<AssetModelCompositeModel>): FluentBuilder = apply { this.assetModelCompositeModels = assetModelCompositeModels }
        override fun assetModelDescription(assetModelDescription: String): FluentBuilder = apply { this.assetModelDescription = assetModelDescription }
        override fun assetModelHierarchies(assetModelHierarchies: List<AssetModelHierarchy>): FluentBuilder = apply { this.assetModelHierarchies = assetModelHierarchies }
        override fun assetModelId(assetModelId: String): FluentBuilder = apply { this.assetModelId = assetModelId }
        override fun assetModelName(assetModelName: String): FluentBuilder = apply { this.assetModelName = assetModelName }
        override fun assetModelProperties(assetModelProperties: List<AssetModelProperty>): FluentBuilder = apply { this.assetModelProperties = assetModelProperties }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
    }
}
