// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class UpdateAccessPolicyRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the access policy.
     */
    val accessPolicyId: String? = builder.accessPolicyId
    /**
     * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
     */
    val accessPolicyIdentity: Identity? = builder.accessPolicyIdentity
    /**
     * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
     */
    val accessPolicyPermission: Permission? = builder.accessPolicyPermission
    /**
     * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     */
    val accessPolicyResource: Resource? = builder.accessPolicyResource
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    val clientToken: String? = builder.clientToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateAccessPolicyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccessPolicyRequest(")
        append("accessPolicyId=$accessPolicyId,")
        append("accessPolicyIdentity=$accessPolicyIdentity,")
        append("accessPolicyPermission=$accessPolicyPermission,")
        append("accessPolicyResource=$accessPolicyResource,")
        append("clientToken=$clientToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicyId?.hashCode() ?: 0
        result = 31 * result + (accessPolicyIdentity?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyPermission?.hashCode() ?: 0)
        result = 31 * result + (accessPolicyResource?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateAccessPolicyRequest

        if (accessPolicyId != other.accessPolicyId) return false
        if (accessPolicyIdentity != other.accessPolicyIdentity) return false
        if (accessPolicyPermission != other.accessPolicyPermission) return false
        if (accessPolicyResource != other.accessPolicyResource) return false
        if (clientToken != other.clientToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateAccessPolicyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateAccessPolicyRequest
        /**
         * The ID of the access policy.
         */
        fun accessPolicyId(accessPolicyId: String): FluentBuilder
        /**
         * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
         */
        fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder
        /**
         * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
         */
        fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder
        /**
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         */
        fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        fun clientToken(clientToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the access policy.
         */
        var accessPolicyId: String?
        /**
         * The identity for this access policy. Choose an Amazon Web Services SSO user, an Amazon Web Services SSO group, or an IAM user.
         */
        var accessPolicyIdentity: Identity?
        /**
         * The permission level for this access policy. Note that a project ADMINISTRATOR is also known as a project owner.
         */
        var accessPolicyPermission: Permission?
        /**
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         */
        var accessPolicyResource: Resource?
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        var clientToken: String?

        fun build(): UpdateAccessPolicyRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        fun accessPolicyIdentity(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyIdentity = Identity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        fun accessPolicyResource(block: Resource.DslBuilder.() -> kotlin.Unit) {
            this.accessPolicyResource = Resource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPolicyId: String? = null
        override var accessPolicyIdentity: Identity? = null
        override var accessPolicyPermission: Permission? = null
        override var accessPolicyResource: Resource? = null
        override var clientToken: String? = null

        constructor(x: UpdateAccessPolicyRequest) : this() {
            this.accessPolicyId = x.accessPolicyId
            this.accessPolicyIdentity = x.accessPolicyIdentity
            this.accessPolicyPermission = x.accessPolicyPermission
            this.accessPolicyResource = x.accessPolicyResource
            this.clientToken = x.clientToken
        }

        override fun build(): UpdateAccessPolicyRequest = UpdateAccessPolicyRequest(this)
        override fun accessPolicyId(accessPolicyId: String): FluentBuilder = apply { this.accessPolicyId = accessPolicyId }
        override fun accessPolicyIdentity(accessPolicyIdentity: Identity): FluentBuilder = apply { this.accessPolicyIdentity = accessPolicyIdentity }
        override fun accessPolicyPermission(accessPolicyPermission: Permission): FluentBuilder = apply { this.accessPolicyPermission = accessPolicyPermission }
        override fun accessPolicyResource(accessPolicyResource: Resource): FluentBuilder = apply { this.accessPolicyResource = accessPolicyResource }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
    }
}
