// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and
 * contiguous time window. You use this window in metrics to aggregate data from properties and other assets.
 * You can use m, h, d, and w
 * when you specify an interval or offset. Note that m represents minutes,
 * and w represents weeks. You can also use s to represent seconds
 * in offset.
 * The interval and offset parameters support the
 * <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format.
 * For example, PT5S represents five seconds, PT5M represents five minutes,
 * and PT5H represents five hours.
 */
class TumblingWindow private constructor(builder: BuilderImpl) {
    /**
     * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
     * IoT SiteWise computes the 1w interval the end of Sunday at midnight
     * each week (UTC), the 1d interval at the end of each day at midnight (UTC), the
     * 1h interval at the end of each hour, and so on.
     * When IoT SiteWise aggregates data points for metric computations, the start of each interval is
     * exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at
     * the end of the interval.
     */
    val interval: String? = builder.interval
    /**
     * The offset for the tumbling window. The offset parameter accepts the following:
     * The offset time.
     * For example, if you specify 18h for offset
     * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
     * If you create the metric before or at 6:00 PM (UTC),
     * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
     * If you create the metric after 6:00 PM (UTC),
     * you get the first aggregation result at 6 PM (UTC) the next day.
     * The ISO 8601 format.
     * For example, if you specify PT18H for offset
     * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
     * If you create the metric before or at 6:00 PM (UTC),
     * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
     * If you create the metric after 6:00 PM (UTC),
     * you get the first aggregation result at 6 PM (UTC) the next day.
     * The 24-hour clock.
     * For example, if you specify 00:03:00 for offset
     * and 5m for interval, and you create the metric at 2 PM (UTC),
     * you get the first aggregation result at 2:03 PM (UTC).
     * You get the second aggregation result at 2:08 PM (UTC).
     * The offset time zone.
     * For example, if you specify 2021-07-23T18:00-08 for offset
     * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
     * If you create the metric before or at 6:00 PM (PST),
     * you get the first aggregation result at 6 PM (PST) on the day when you create the metric.
     * If you create the metric after 6:00 PM (PST),
     * you get the first aggregation result at 6 PM (PST) the next day.
     */
    val offset: String? = builder.offset

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TumblingWindow = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TumblingWindow(")
        append("interval=$interval,")
        append("offset=$offset)")
    }

    override fun hashCode(): kotlin.Int {
        var result = interval?.hashCode() ?: 0
        result = 31 * result + (offset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TumblingWindow

        if (interval != other.interval) return false
        if (offset != other.offset) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TumblingWindow = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TumblingWindow
        /**
         * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
         * IoT SiteWise computes the 1w interval the end of Sunday at midnight
         * each week (UTC), the 1d interval at the end of each day at midnight (UTC), the
         * 1h interval at the end of each hour, and so on.
         * When IoT SiteWise aggregates data points for metric computations, the start of each interval is
         * exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at
         * the end of the interval.
         */
        fun interval(interval: String): FluentBuilder
        /**
         * The offset for the tumbling window. The offset parameter accepts the following:
         * The offset time.
         * For example, if you specify 18h for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
         * If you create the metric after 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) the next day.
         * The ISO 8601 format.
         * For example, if you specify PT18H for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
         * If you create the metric after 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) the next day.
         * The 24-hour clock.
         * For example, if you specify 00:03:00 for offset
         * and 5m for interval, and you create the metric at 2 PM (UTC),
         * you get the first aggregation result at 2:03 PM (UTC).
         * You get the second aggregation result at 2:08 PM (UTC).
         * The offset time zone.
         * For example, if you specify 2021-07-23T18:00-08 for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (PST),
         * you get the first aggregation result at 6 PM (PST) on the day when you create the metric.
         * If you create the metric after 6:00 PM (PST),
         * you get the first aggregation result at 6 PM (PST) the next day.
         */
        fun offset(offset: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.
         * IoT SiteWise computes the 1w interval the end of Sunday at midnight
         * each week (UTC), the 1d interval at the end of each day at midnight (UTC), the
         * 1h interval at the end of each hour, and so on.
         * When IoT SiteWise aggregates data points for metric computations, the start of each interval is
         * exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at
         * the end of the interval.
         */
        var interval: String?
        /**
         * The offset for the tumbling window. The offset parameter accepts the following:
         * The offset time.
         * For example, if you specify 18h for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
         * If you create the metric after 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) the next day.
         * The ISO 8601 format.
         * For example, if you specify PT18H for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.
         * If you create the metric after 6:00 PM (UTC),
         * you get the first aggregation result at 6 PM (UTC) the next day.
         * The 24-hour clock.
         * For example, if you specify 00:03:00 for offset
         * and 5m for interval, and you create the metric at 2 PM (UTC),
         * you get the first aggregation result at 2:03 PM (UTC).
         * You get the second aggregation result at 2:08 PM (UTC).
         * The offset time zone.
         * For example, if you specify 2021-07-23T18:00-08 for offset
         * and 1d for interval, IoT SiteWise aggregates data in one of the following ways:
         * If you create the metric before or at 6:00 PM (PST),
         * you get the first aggregation result at 6 PM (PST) on the day when you create the metric.
         * If you create the metric after 6:00 PM (PST),
         * you get the first aggregation result at 6 PM (PST) the next day.
         */
        var offset: String?

        fun build(): TumblingWindow
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var interval: String? = null
        override var offset: String? = null

        constructor(x: TumblingWindow) : this() {
            this.interval = x.interval
            this.offset = x.offset
        }

        override fun build(): TumblingWindow = TumblingWindow(this)
        override fun interval(interval: String): FluentBuilder = apply { this.interval = interval }
        override fun offset(offset: String): FluentBuilder = apply { this.offset = offset }
    }
}
