// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains an asset transform property. A transform is a one-to-one mapping of a property's
 * data points from one form to another. For example, you can use a transform to convert a
 * Celsius data stream to Fahrenheit by applying the transformation expression to each data point
 * of the Celsius stream. A transform can only have a data type of DOUBLE and
 * consume properties with data types of INTEGER or DOUBLE.
 * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms">Transforms in the IoT SiteWise User Guide.
 */
class Transform private constructor(builder: BuilderImpl) {
    /**
     * The mathematical expression that defines the transformation function. You can specify up
     * to 10 variables per expression. You can specify up to 10 functions per
     * expression.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val expression: String? = builder.expression
    /**
     * The processing configuration for the given transform property.
     * You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud.
     * You can also configure transforms to be computed at the edge or in the cloud.
     */
    val processingConfig: TransformProcessingConfig? = builder.processingConfig
    /**
     * The list of variables used in the expression.
     */
    val variables: List<ExpressionVariable>? = builder.variables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Transform = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Transform(")
        append("expression=$expression,")
        append("processingConfig=$processingConfig,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression?.hashCode() ?: 0
        result = 31 * result + (processingConfig?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Transform

        if (expression != other.expression) return false
        if (processingConfig != other.processingConfig) return false
        if (variables != other.variables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Transform = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Transform
        /**
         * The mathematical expression that defines the transformation function. You can specify up
         * to 10 variables per expression. You can specify up to 10 functions per
         * expression.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun expression(expression: String): FluentBuilder
        /**
         * The processing configuration for the given transform property.
         * You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud.
         * You can also configure transforms to be computed at the edge or in the cloud.
         */
        fun processingConfig(processingConfig: TransformProcessingConfig): FluentBuilder
        /**
         * The list of variables used in the expression.
         */
        fun variables(variables: List<ExpressionVariable>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The mathematical expression that defines the transformation function. You can specify up
         * to 10 variables per expression. You can specify up to 10 functions per
         * expression.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var expression: String?
        /**
         * The processing configuration for the given transform property.
         * You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud.
         * You can also configure transforms to be computed at the edge or in the cloud.
         */
        var processingConfig: TransformProcessingConfig?
        /**
         * The list of variables used in the expression.
         */
        var variables: List<ExpressionVariable>?

        fun build(): Transform
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.TransformProcessingConfig] inside the given [block]
         */
        fun processingConfig(block: TransformProcessingConfig.DslBuilder.() -> kotlin.Unit) {
            this.processingConfig = TransformProcessingConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var expression: String? = null
        override var processingConfig: TransformProcessingConfig? = null
        override var variables: List<ExpressionVariable>? = null

        constructor(x: Transform) : this() {
            this.expression = x.expression
            this.processingConfig = x.processingConfig
            this.variables = x.variables
        }

        override fun build(): Transform = Transform(this)
        override fun expression(expression: String): FluentBuilder = apply { this.expression = expression }
        override fun processingConfig(processingConfig: TransformProcessingConfig): FluentBuilder = apply { this.processingConfig = processingConfig }
        override fun variables(variables: List<ExpressionVariable>): FluentBuilder = apply { this.variables = variables }
    }
}
