// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains a list of value updates for an asset property in the list of asset entries
 * consumed by the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue API
 * operation.
 */
class PutAssetPropertyValueEntry private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset to update.
     */
    val assetId: String? = builder.assetId
    /**
     * The user specified ID for the entry. You can use this ID to identify which entries
     * failed.
     */
    val entryId: String? = builder.entryId
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val propertyAlias: String? = builder.propertyAlias
    /**
     * The ID of the asset property for this entry.
     */
    val propertyId: String? = builder.propertyId
    /**
     * The list of property values to upload. You can specify up to 10
     * propertyValues array elements.
     */
    val propertyValues: List<AssetPropertyValue>? = builder.propertyValues

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutAssetPropertyValueEntry = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutAssetPropertyValueEntry(")
        append("assetId=$assetId,")
        append("entryId=$entryId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("propertyValues=$propertyValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (entryId?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (propertyValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutAssetPropertyValueEntry

        if (assetId != other.assetId) return false
        if (entryId != other.entryId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (propertyValues != other.propertyValues) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutAssetPropertyValueEntry = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutAssetPropertyValueEntry
        /**
         * The ID of the asset to update.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The user specified ID for the entry. You can use this ID to identify which entries
         * failed.
         */
        fun entryId(entryId: String): FluentBuilder
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun propertyAlias(propertyAlias: String): FluentBuilder
        /**
         * The ID of the asset property for this entry.
         */
        fun propertyId(propertyId: String): FluentBuilder
        /**
         * The list of property values to upload. You can specify up to 10
         * propertyValues array elements.
         */
        fun propertyValues(propertyValues: List<AssetPropertyValue>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset to update.
         */
        var assetId: String?
        /**
         * The user specified ID for the entry. You can use this ID to identify which entries
         * failed.
         */
        var entryId: String?
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var propertyAlias: String?
        /**
         * The ID of the asset property for this entry.
         */
        var propertyId: String?
        /**
         * The list of property values to upload. You can specify up to 10
         * propertyValues array elements.
         */
        var propertyValues: List<AssetPropertyValue>?

        fun build(): PutAssetPropertyValueEntry
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var entryId: String? = null
        override var propertyAlias: String? = null
        override var propertyId: String? = null
        override var propertyValues: List<AssetPropertyValue>? = null

        constructor(x: PutAssetPropertyValueEntry) : this() {
            this.assetId = x.assetId
            this.entryId = x.entryId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.propertyValues = x.propertyValues
        }

        override fun build(): PutAssetPropertyValueEntry = PutAssetPropertyValueEntry(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun entryId(entryId: String): FluentBuilder = apply { this.entryId = entryId }
        override fun propertyAlias(propertyAlias: String): FluentBuilder = apply { this.propertyAlias = propertyAlias }
        override fun propertyId(propertyId: String): FluentBuilder = apply { this.propertyId = propertyId }
        override fun propertyValues(propertyValues: List<AssetPropertyValue>): FluentBuilder = apply { this.propertyValues = propertyValues }
    }
}
