// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value
 * updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services in the IoT SiteWise User Guide.
 */
class PropertyNotification private constructor(builder: BuilderImpl) {
    /**
     * The current notification state.
     */
    val state: PropertyNotificationState? = builder.state
    /**
     * The MQTT topic to which IoT SiteWise publishes property value update notifications.
     */
    val topic: String? = builder.topic

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PropertyNotification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PropertyNotification(")
        append("state=$state,")
        append("topic=$topic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = state?.hashCode() ?: 0
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PropertyNotification

        if (state != other.state) return false
        if (topic != other.topic) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PropertyNotification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PropertyNotification
        /**
         * The current notification state.
         */
        fun state(state: PropertyNotificationState): FluentBuilder
        /**
         * The MQTT topic to which IoT SiteWise publishes property value update notifications.
         */
        fun topic(topic: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The current notification state.
         */
        var state: PropertyNotificationState?
        /**
         * The MQTT topic to which IoT SiteWise publishes property value update notifications.
         */
        var topic: String?

        fun build(): PropertyNotification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var state: PropertyNotificationState? = null
        override var topic: String? = null

        constructor(x: PropertyNotification) : this() {
            this.state = x.state
            this.topic = x.topic
        }

        override fun build(): PropertyNotification = PropertyNotification(this)
        override fun state(state: PropertyNotificationState): FluentBuilder = apply { this.state = state }
        override fun topic(topic: String): FluentBuilder = apply { this.topic = topic }
    }
}
