// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains asset property information.
 */
class Property private constructor(builder: BuilderImpl) {
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path
     * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
     * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
     * IoT SiteWise User Guide.
     */
    val alias: String? = builder.alias
    /**
     * The property data type.
     */
    val dataType: PropertyDataType? = builder.dataType
    /**
     * The ID of the asset property.
     */
    val id: String? = builder.id
    /**
     * The name of the property.
     */
    val name: String? = builder.name
    /**
     * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
     */
    val notification: PropertyNotification? = builder.notification
    /**
     * The property type (see PropertyType). A property contains one type.
     */
    val type: PropertyType? = builder.type
    /**
     * The unit (such as Newtons or RPM) of the asset property.
     */
    val unit: String? = builder.unit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Property = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Property(")
        append("alias=$alias,")
        append("dataType=$dataType,")
        append("id=$id,")
        append("name=$name,")
        append("notification=$notification,")
        append("type=$type,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Property

        if (alias != other.alias) return false
        if (dataType != other.dataType) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (notification != other.notification) return false
        if (type != other.type) return false
        if (unit != other.unit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Property = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Property
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The property data type.
         */
        fun dataType(dataType: PropertyDataType): FluentBuilder
        /**
         * The ID of the asset property.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the property.
         */
        fun name(name: String): FluentBuilder
        /**
         * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
         */
        fun notification(notification: PropertyNotification): FluentBuilder
        /**
         * The property type (see PropertyType). A property contains one type.
         */
        fun type(type: PropertyType): FluentBuilder
        /**
         * The unit (such as Newtons or RPM) of the asset property.
         */
        fun unit(unit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path
         * (for example, /company/windfarm/3/turbine/7/temperature). For more information, see
         * <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties in the
         * IoT SiteWise User Guide.
         */
        var alias: String?
        /**
         * The property data type.
         */
        var dataType: PropertyDataType?
        /**
         * The ID of the asset property.
         */
        var id: String?
        /**
         * The name of the property.
         */
        var name: String?
        /**
         * The asset property's notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty.
         */
        var notification: PropertyNotification?
        /**
         * The property type (see PropertyType). A property contains one type.
         */
        var type: PropertyType?
        /**
         * The unit (such as Newtons or RPM) of the asset property.
         */
        var unit: String?

        fun build(): Property
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyNotification] inside the given [block]
         */
        fun notification(block: PropertyNotification.DslBuilder.() -> kotlin.Unit) {
            this.notification = PropertyNotification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyType] inside the given [block]
         */
        fun type(block: PropertyType.DslBuilder.() -> kotlin.Unit) {
            this.type = PropertyType.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alias: String? = null
        override var dataType: PropertyDataType? = null
        override var id: String? = null
        override var name: String? = null
        override var notification: PropertyNotification? = null
        override var type: PropertyType? = null
        override var unit: String? = null

        constructor(x: Property) : this() {
            this.alias = x.alias
            this.dataType = x.dataType
            this.id = x.id
            this.name = x.name
            this.notification = x.notification
            this.type = x.type
            this.unit = x.unit
        }

        override fun build(): Property = Property(this)
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun dataType(dataType: PropertyDataType): FluentBuilder = apply { this.dataType = dataType }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun notification(notification: PropertyNotification): FluentBuilder = apply { this.notification = notification }
        override fun type(type: PropertyType): FluentBuilder = apply { this.type = type }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
    }
}
