// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a portal summary.
 */
class PortalSummary private constructor(builder: BuilderImpl) {
    /**
     * The date the portal was created, in Unix epoch time.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * The portal's description.
     */
    val description: String? = builder.description
    /**
     * The ID of the portal.
     */
    val id: String? = builder.id
    /**
     * The date the portal was last updated, in Unix epoch time.
     */
    val lastUpdateDate: Instant? = builder.lastUpdateDate
    /**
     * The name of the portal.
     */
    val name: String? = builder.name
    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
     * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
     * IoT SiteWise User Guide.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
     * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
     * IoT SiteWise console to get a URL that you can use to access the portal.
     */
    val startUrl: String? = builder.startUrl
    /**
     * Contains information about the current status of a portal.
     */
    val status: PortalStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PortalSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PortalSummary(")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("startUrl=$startUrl,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (startUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PortalSummary

        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (startUrl != other.startUrl) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PortalSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PortalSummary
        /**
         * The date the portal was created, in Unix epoch time.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * The portal's description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the portal.
         */
        fun id(id: String): FluentBuilder
        /**
         * The date the portal was last updated, in Unix epoch time.
         */
        fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder
        /**
         * The name of the portal.
         */
        fun name(name: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        fun startUrl(startUrl: String): FluentBuilder
        /**
         * Contains information about the current status of a portal.
         */
        fun status(status: PortalStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date the portal was created, in Unix epoch time.
         */
        var creationDate: Instant?
        /**
         * The portal's description.
         */
        var description: String?
        /**
         * The ID of the portal.
         */
        var id: String?
        /**
         * The date the portal was last updated, in Unix epoch time.
         */
        var lastUpdateDate: Instant?
        /**
         * The name of the portal.
         */
        var name: String?
        /**
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN of the service role that allows the portal's users to access your IoT SiteWise
         * resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor in the
         * IoT SiteWise User Guide.
         */
        var roleArn: String?
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that
         * use Amazon Web Services SSO for authentication. For portals that use IAM for authentication, you must use the
         * IoT SiteWise console to get a URL that you can use to access the portal.
         */
        var startUrl: String?
        /**
         * Contains information about the current status of a portal.
         */
        var status: PortalStatus?

        fun build(): PortalSummary
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PortalStatus] inside the given [block]
         */
        fun status(block: PortalStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = PortalStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdateDate: Instant? = null
        override var name: String? = null
        override var roleArn: String? = null
        override var startUrl: String? = null
        override var status: PortalStatus? = null

        constructor(x: PortalSummary) : this() {
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.roleArn = x.roleArn
            this.startUrl = x.startUrl
            this.status = x.status
        }

        override fun build(): PortalSummary = PortalSummary(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdateDate(lastUpdateDate: Instant): FluentBuilder = apply { this.lastUpdateDate = lastUpdateDate }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun startUrl(startUrl: String): FluentBuilder = apply { this.startUrl = startUrl }
        override fun status(status: PortalStatus): FluentBuilder = apply { this.status = status }
    }
}
