// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



/**
 * Contains an asset metric property. With metrics, you can calculate aggregate functions,
 * such as an average, maximum, or minimum, as specified through an expression. A metric maps
 * several values to a single value (such as a sum).
 * The maximum number of dependent/cascading variables used in any one metric calculation is
 * 10. Therefore, a root metric can have
 * up to 10 cascading metrics in its computational dependency
 * tree. Additionally, a metric can only have a data type of DOUBLE and consume
 * properties with data types of INTEGER or DOUBLE.
 * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics">Metrics in the IoT SiteWise User Guide.
 */
class Metric private constructor(builder: BuilderImpl) {
    /**
     * The mathematical expression that defines the metric aggregation function. You can specify
     * up to 10 variables per expression. You can specify up to 10 functions
     * per expression.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
     */
    val expression: String? = builder.expression
    /**
     * The processing configuration for the given metric property.
     * You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud.
     * By default, metrics are forwarded to the cloud.
     */
    val processingConfig: MetricProcessingConfig? = builder.processingConfig
    /**
     * The list of variables used in the expression.
     */
    val variables: List<ExpressionVariable>? = builder.variables
    /**
     * The window (time interval) over which IoT SiteWise computes the metric's aggregation expression.
     * IoT SiteWise computes one data point per window.
     */
    val window: MetricWindow? = builder.window

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Metric = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Metric(")
        append("expression=$expression,")
        append("processingConfig=$processingConfig,")
        append("variables=$variables,")
        append("window=$window)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression?.hashCode() ?: 0
        result = 31 * result + (processingConfig?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (window?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Metric

        if (expression != other.expression) return false
        if (processingConfig != other.processingConfig) return false
        if (variables != other.variables) return false
        if (window != other.window) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Metric = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Metric
        /**
         * The mathematical expression that defines the metric aggregation function. You can specify
         * up to 10 variables per expression. You can specify up to 10 functions
         * per expression.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        fun expression(expression: String): FluentBuilder
        /**
         * The processing configuration for the given metric property.
         * You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud.
         * By default, metrics are forwarded to the cloud.
         */
        fun processingConfig(processingConfig: MetricProcessingConfig): FluentBuilder
        /**
         * The list of variables used in the expression.
         */
        fun variables(variables: List<ExpressionVariable>): FluentBuilder
        /**
         * The window (time interval) over which IoT SiteWise computes the metric's aggregation expression.
         * IoT SiteWise computes one data point per window.
         */
        fun window(window: MetricWindow): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The mathematical expression that defines the metric aggregation function. You can specify
         * up to 10 variables per expression. You can specify up to 10 functions
         * per expression.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas in the IoT SiteWise User Guide.
         */
        var expression: String?
        /**
         * The processing configuration for the given metric property.
         * You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud.
         * By default, metrics are forwarded to the cloud.
         */
        var processingConfig: MetricProcessingConfig?
        /**
         * The list of variables used in the expression.
         */
        var variables: List<ExpressionVariable>?
        /**
         * The window (time interval) over which IoT SiteWise computes the metric's aggregation expression.
         * IoT SiteWise computes one data point per window.
         */
        var window: MetricWindow?

        fun build(): Metric
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.MetricProcessingConfig] inside the given [block]
         */
        fun processingConfig(block: MetricProcessingConfig.DslBuilder.() -> kotlin.Unit) {
            this.processingConfig = MetricProcessingConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.MetricWindow] inside the given [block]
         */
        fun window(block: MetricWindow.DslBuilder.() -> kotlin.Unit) {
            this.window = MetricWindow.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var expression: String? = null
        override var processingConfig: MetricProcessingConfig? = null
        override var variables: List<ExpressionVariable>? = null
        override var window: MetricWindow? = null

        constructor(x: Metric) : this() {
            this.expression = x.expression
            this.processingConfig = x.processingConfig
            this.variables = x.variables
            this.window = x.window
        }

        override fun build(): Metric = Metric(this)
        override fun expression(expression: String): FluentBuilder = apply { this.expression = expression }
        override fun processingConfig(processingConfig: MetricProcessingConfig): FluentBuilder = apply { this.processingConfig = processingConfig }
        override fun variables(variables: List<ExpressionVariable>): FluentBuilder = apply { this.variables = variables }
        override fun window(window: MetricWindow): FluentBuilder = apply { this.window = window }
    }
}
