// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model



class ListAssociatedAssetsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the asset to query.
     */
    val assetId: String? = builder.assetId
    /**
     * The ID of the hierarchy by which child assets are associated to the asset. To find a
     * hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel operations. This
     * parameter is required if you choose CHILD for
     * traversalDirection.
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
     */
    val hierarchyId: String? = builder.hierarchyId
    /**
     * The maximum number of results to return for each paginated request.
     * Default: 50
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The direction to list associated assets. Choose one of the following options:
     * CHILD – The list includes all child assets associated to the
     * asset. The hierarchyId parameter is required if you choose
     * CHILD.
     * PARENT – The list includes the asset's parent asset.
     * Default: CHILD
     */
    val traversalDirection: TraversalDirection? = builder.traversalDirection

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAssociatedAssetsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAssociatedAssetsRequest(")
        append("assetId=$assetId,")
        append("hierarchyId=$hierarchyId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("traversalDirection=$traversalDirection)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (hierarchyId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (traversalDirection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAssociatedAssetsRequest

        if (assetId != other.assetId) return false
        if (hierarchyId != other.hierarchyId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (traversalDirection != other.traversalDirection) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAssociatedAssetsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAssociatedAssetsRequest
        /**
         * The ID of the asset to query.
         */
        fun assetId(assetId: String): FluentBuilder
        /**
         * The ID of the hierarchy by which child assets are associated to the asset. To find a
         * hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel operations. This
         * parameter is required if you choose CHILD for
         * traversalDirection.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         */
        fun hierarchyId(hierarchyId: String): FluentBuilder
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to be used for the next set of paginated results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The direction to list associated assets. Choose one of the following options:
         * CHILD – The list includes all child assets associated to the
         * asset. The hierarchyId parameter is required if you choose
         * CHILD.
         * PARENT – The list includes the asset's parent asset.
         * Default: CHILD
         */
        fun traversalDirection(traversalDirection: TraversalDirection): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the asset to query.
         */
        var assetId: String?
        /**
         * The ID of the hierarchy by which child assets are associated to the asset. To find a
         * hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel operations. This
         * parameter is required if you choose CHILD for
         * traversalDirection.
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies in the IoT SiteWise User Guide.
         */
        var hierarchyId: String?
        /**
         * The maximum number of results to return for each paginated request.
         * Default: 50
         */
        var maxResults: Int?
        /**
         * The token to be used for the next set of paginated results.
         */
        var nextToken: String?
        /**
         * The direction to list associated assets. Choose one of the following options:
         * CHILD – The list includes all child assets associated to the
         * asset. The hierarchyId parameter is required if you choose
         * CHILD.
         * PARENT – The list includes the asset's parent asset.
         * Default: CHILD
         */
        var traversalDirection: TraversalDirection?

        fun build(): ListAssociatedAssetsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assetId: String? = null
        override var hierarchyId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var traversalDirection: TraversalDirection? = null

        constructor(x: ListAssociatedAssetsRequest) : this() {
            this.assetId = x.assetId
            this.hierarchyId = x.hierarchyId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.traversalDirection = x.traversalDirection
        }

        override fun build(): ListAssociatedAssetsRequest = ListAssociatedAssetsRequest(this)
        override fun assetId(assetId: String): FluentBuilder = apply { this.assetId = assetId }
        override fun hierarchyId(hierarchyId: String): FluentBuilder = apply { this.hierarchyId = hierarchyId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun traversalDirection(traversalDirection: TraversalDirection): FluentBuilder = apply { this.traversalDirection = traversalDirection }
    }
}
